/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.commons.tracemetamodel;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class StepStrings {
  public static final String implicitStepSuffix = "_ImplicitStep";

  public static final String abstractSubStepSuffix = "_AbstractSubStep";

  public static final String globalImplicitStepName = "ImplicitStep";

  public static final String package_BigSteps = "BigSteps";

  public static final String ref_BigStepToSub = "subSteps";

  public static String implicitStepClassName(final EClass macroStepClass) {
    String _name = macroStepClass.getName();
    return (_name + StepStrings.implicitStepSuffix);
  }

  public static String stepClassName(final EClass containingClass, final EOperation rule) {
    String _xifexpression = null;
    if ((containingClass != null)) {
      String _firstUpper = StringExtensions.toFirstUpper(EcoreCraftingUtil.getFQN(containingClass, "_"));
      _xifexpression = (_firstUpper + "_");
    } else {
      _xifexpression = "Root_";
    }
    final String prefix = _xifexpression;
    String _firstUpper_1 = StringExtensions.toFirstUpper(rule.getName());
    return (prefix + _firstUpper_1);
  }

  public static String subStepClassName(final EClass containingClass, final EOperation rule) {
    return StepStrings.stepClassName(containingClass, rule);
  }

  public static String abstractSubStepClassName(final EClass containingClass, final EOperation rule) {
    String _stepClassName = StepStrings.stepClassName(containingClass, rule);
    return (_stepClassName + StepStrings.abstractSubStepSuffix);
  }

  public static String implicitStepClassName(final EClass containingClass, final EOperation rule) {
    String _stepClassName = StepStrings.stepClassName(containingClass, rule);
    return (_stepClassName + StepStrings.implicitStepSuffix);
  }
}
