/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Arguments for 'Initialize' request.
 */
@SuppressWarnings("all")
public class InitializeArguments {
  /**
   * Regular expression of the engineId of the engine(s) this client is controling/monitoring. (optional, default is '.*')
   */
  private String engineIdRegExp;

  /**
   * Regular expression of the engineId of the engine(s) this client is controling/monitoring. (optional, default is '.*')
   */
  @Pure
  public String getEngineIdRegExp() {
    return this.engineIdRegExp;
  }

  /**
   * Regular expression of the engineId of the engine(s) this client is controling/monitoring. (optional, default is '.*')
   */
  public void setEngineIdRegExp(final String engineIdRegExp) {
    this.engineIdRegExp = engineIdRegExp;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("engineIdRegExp", this.engineIdRegExp);
    return b.toString();
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    InitializeArguments other = (InitializeArguments) obj;
    if (this.engineIdRegExp == null) {
      if (other.engineIdRegExp != null)
        return false;
    } else if (!this.engineIdRegExp.equals(other.engineIdRegExp))
      return false;
    return true;
  }

  @Override
  @Pure
  public int hashCode() {
    return 31 * 1 + ((this.engineIdRegExp== null) ? 0 : this.engineIdRegExp.hashCode());
  }
}
