/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.utils;

import fr.inria.aoste.timesquare.backend.manager.utils.EventEnumeratorPair;
import fr.inria.aoste.timesquare.backend.manager.utils.FilterClockEntity;
import fr.inria.aoste.timesquare.backend.manager.utils.FilterDiscretize;
import fr.inria.aoste.timesquare.backend.manager.utils.FilterEventEnumerator;
import fr.inria.aoste.timesquare.backend.manager.utils.FilterReferencedObject;
import fr.inria.aoste.timesquare.backend.manager.utils.IFilter;
import fr.inria.aoste.timesquare.backend.manager.utils.PairClockModelElementReference;
import fr.inria.aoste.timesquare.trace.util.adapter.IModelAdapter;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.ArrayList;

public class Filter {
    public static final FilterEventEnumerator FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_CONSUME = new FilterEventEnumerator(IModelAdapter.EventEnumerator.CONSUME);
    public static final FilterEventEnumerator FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_FINISH = new FilterEventEnumerator(IModelAdapter.EventEnumerator.FINISH);
    public static final FilterEventEnumerator FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_PRODUCE = new FilterEventEnumerator(IModelAdapter.EventEnumerator.PRODUCE);
    public static final FilterEventEnumerator FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_RECEIVE = new FilterEventEnumerator(IModelAdapter.EventEnumerator.RECEIVE);
    public static final FilterEventEnumerator FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_SEND = new FilterEventEnumerator(IModelAdapter.EventEnumerator.SEND);
    public static final FilterEventEnumerator FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_START = new FilterEventEnumerator(IModelAdapter.EventEnumerator.START);
    public static final FilterEventEnumerator FILTER_MODELELEMENTREFERENCE_EVENTENUMERATORUNDEFINED = new FilterEventEnumerator(IModelAdapter.EventEnumerator.UNDEFINED);
    public static final FilterReferencedObject FILTER_REFERENCED_OBJECT = new FilterReferencedObject();
    public static final FilterClockEntity FILTER_CLOCK_ENTITY_DISCRETIZE = new FilterClockEntity(new FilterDiscretize());

    public static <T, T2 extends T> boolean containt(Iterable<T2> lst, IFilter<T> filter) {
        for (T2 t : lst) {
            if (!filter.accept(t)) continue;
            return true;
        }
        return false;
    }

    public static <T, T2 extends T> int count(Iterable<T2> lst, IFilter<T> filter) {
        int n = 0;
        for (T2 t : lst) {
            if (!filter.accept(t)) continue;
            ++n;
        }
        return n;
    }

    public static <T, T2 extends T> ArrayList<T2> sublist(Iterable<T2> lst, IFilter<T> filter) {
        ArrayList<T2> liste = new ArrayList<T2>();
        for (T2 t : lst) {
            if (!filter.accept(t)) continue;
            liste.add(t);
        }
        return liste;
    }

    public static <TOUT extends PairClockModelElementReference> ArrayList<TOUT> createPairClockModelElementReference(EventEnumeratorPair eep, Iterable<ModelElementReference> lst, ICreatePairClockModelElementReference<TOUT> creator) {
        ArrayList<TOUT> liste = new ArrayList<TOUT>();
        if (eep != null) {
            ArrayList<ModelElementReference> listesrc = Filter.sublist(lst, Filter.getFilterEventEnumerator(eep.getSource()));
            ArrayList<ModelElementReference> listedst = Filter.sublist(lst, Filter.getFilterEventEnumerator(eep.getDestination()));
            for (ModelElementReference mersrc : listesrc) {
                for (ModelElementReference merdst : listedst) {
                    TOUT t = creator.create(mersrc, merdst);
                    if (t == null) continue;
                    liste.add(t);
                }
            }
        }
        return liste;
    }

    public static FilterEventEnumerator getFilterEventEnumerator(IModelAdapter.EventEnumerator ee) {
        if (ee != null) {
            switch (ee) {
                case CONSUME: {
                    return FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_CONSUME;
                }
                case FINISH: {
                    return FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_FINISH;
                }
                case PRODUCE: {
                    return FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_PRODUCE;
                }
                case RECEIVE: {
                    return FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_RECEIVE;
                }
                case SEND: {
                    return FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_SEND;
                }
                case START: {
                    return FILTER_MODELELEMENTREFERENCE_EVENTENUMERATOR_START;
                }
                case UNDEFINED: {
                    return FILTER_MODELELEMENTREFERENCE_EVENTENUMERATORUNDEFINED;
                }
            }
        }
        return null;
    }

    public static interface ICreatePairClockModelElementReference<TOUT extends PairClockModelElementReference> {
        public TOUT create(ModelElementReference var1, ModelElementReference var2);
    }
}

