/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline;

import java.text.MessageFormat;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.m2m.internal.qvt.oml.cst.ContextualPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.AbstractInformationControl;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.OutlineContentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.OutlineLabelProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.OutlineSorter;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.TextMessages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.actions.LexicalSortingAction;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.actions.ShowFQNAction;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class QvtOutlineInformationControl
extends AbstractInformationControl {
    private KeyAdapter myKeyAdapter;
    private OutlineContentProvider myOutlineContentProvider;
    private OutlineLabelProvider myLabelProvider;
    private OutlineSorter myOutlineSorter;
    private ShowFQNAction myShowFQNAction;
    private LexicalSortingAction myLexicalSortingAction;
    private final QvtEditor myEditor;
    private final ISourceViewer mySourceViewer;

    public QvtOutlineInformationControl(Shell parent, int shellStyle, int treeStyle, String commandId, QvtEditor editor, ISourceViewer sourceViewer) {
        super(parent, shellStyle, treeStyle, commandId, true);
        this.myEditor = editor;
        this.mySourceViewer = sourceViewer;
    }

    @Override
    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        TreeViewer treeViewer = new TreeViewer(tree);
        this.myShowFQNAction = new ShowFQNAction(treeViewer, this.getDialogSettings());
        this.myLabelProvider = new OutlineLabelProvider(this);
        treeViewer.setLabelProvider((IBaseLabelProvider)this.myLabelProvider);
        this.myLexicalSortingAction = new LexicalSortingAction(treeViewer, this.getDialogSettings());
        this.myOutlineContentProvider = new OutlineContentProvider(this, false);
        treeViewer.setContentProvider((IContentProvider)this.myOutlineContentProvider);
        this.myOutlineSorter = new OutlineSorter(this);
        treeViewer.setComparator((ViewerComparator)this.myOutlineSorter);
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return treeViewer;
    }

    @Override
    protected String getStatusFieldText() {
        TriggerSequence[] sequences = this.getInvokingCommandKeySequences();
        if (sequences == null || sequences.length == 0) {
            return "";
        }
        String keySequence = sequences[0].format();
        if (this.myOutlineContentProvider.isShowingImportedMembers()) {
            return MessageFormat.format(TextMessages.QvtOutlineInformationControl_statusFieldText_hideInheritedMembers, keySequence);
        }
        return MessageFormat.format(TextMessages.QvtOutlineInformationControl_statusFieldText_showInheritedMembers, keySequence);
    }

    @Override
    protected String getId() {
        return QvtOutlineInformationControl.class.getName();
    }

    public QvtEditor getEditor() {
        return this.myEditor;
    }

    public ISourceViewer getSourceViewer() {
        return this.mySourceViewer;
    }

    public ShowFQNAction getShowFQNAction() {
        return this.myShowFQNAction;
    }

    public LexicalSortingAction getLexicalSortingAction() {
        return this.myLexicalSortingAction;
    }

    @Override
    public void setInput(Object information) {
        this.inputChanged(information, information);
    }

    private KeyAdapter getKeyAdapter() {
        if (this.myKeyAdapter == null) {
            this.myKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    TriggerSequence[] sequences = QvtOutlineInformationControl.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            QvtOutlineInformationControl.this.toggleShowInheritedMembers();
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.myKeyAdapter;
    }

    @Override
    protected void handleStatusFieldClicked() {
        this.toggleShowInheritedMembers();
    }

    protected void toggleShowInheritedMembers() {
        this.myOutlineContentProvider.toggleShowInheritedMembers();
        this.updateStatusFieldText();
    }

    @Override
    protected void fillViewMenu(IMenuManager viewMenu) {
        super.fillViewMenu(viewMenu);
        viewMenu.add((IContributionItem)new Separator("View Options"));
        viewMenu.add((IAction)this.myShowFQNAction);
        viewMenu.add((IContributionItem)new Separator("Sorters"));
        viewMenu.add((IAction)this.myLexicalSortingAction);
    }

    @Override
    protected boolean matchesTextPattern(Object element) {
        if (this.myLabelProvider.isShowFQN()) {
            SimpleNameCS simpleNameCS = null;
            if (element instanceof MappingMethodCS) {
                MappingMethodCS mappingMethodCS = (MappingMethodCS)element;
                MappingDeclarationCS mappingDeclarationCS = mappingMethodCS.getMappingDeclarationCS();
                if (mappingDeclarationCS != null) {
                    simpleNameCS = mappingDeclarationCS.getSimpleNameCS();
                }
            } else if (element instanceof ContextualPropertyCS) {
                ContextualPropertyCS contextualPropertyCS = (ContextualPropertyCS)element;
                simpleNameCS = contextualPropertyCS.getSimpleNameCS();
            }
            if (simpleNameCS != null) {
                String simpleName = simpleNameCS.getValue();
                return simpleName != null && this.getStringMatcher().match(simpleName);
            }
        }
        return false;
    }
}

