/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.trace.util;

import fr.inria.aoste.timesquare.trace.util.HelperFactory;
import fr.inria.aoste.timesquare.trace.util.TimeBase;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.trace.DiscretizedClockStep;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.InterDiscretizedSteps;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.PhysicalBase;
import fr.inria.aoste.trace.PhysicalSteps;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class HelperPhysicalBase {
    PhysicalBase ph;
    DiscretizedClockStep dcs = null;
    InterDiscretizedSteps ids = null;

    public HelperPhysicalBase(PhysicalBase ph) {
        this.ph = ph;
    }

    public boolean isFixed(LogicalStep step) {
        return HelperFactory.isFixed(this.ph, step);
    }

    public PhysicalSteps createPhysicalSteps(LogicalStep steps) {
        EventOccurrence e = HelperFactory.getEventOccurence(steps, this.ph);
        if (e != null && e.getFState() == FiredStateKind.TICK) {
            DiscretizedClockStep ps = HelperFactory.createDiscretizedClockStep(steps);
            this.ph.getPhysicalSteps().add((Object)ps);
            this.dcs = ps;
            if (this.ids != null) {
                this.ids.setNextFixStep(ps);
            }
            this.ids = null;
            EObject eo = (EObject)((ModelElementReference)this.ph.getRelatedDenseClock()).getElementRef().get(0);
            List<TimeBase> listValues = AdapterRegistry.getAdapter(eo).getDiscretyzeByValue(eo);
            double resolution = 0.0;
            if (listValues.size() != 0) {
                resolution = listValues.get(0).getBase();
            }
            if (resolution != 0.0) {
                ps.setTimestamp(1.0 * (double)e.getCounter() * resolution);
            } else {
                ps.setTimestamp((double)e.getCounter());
            }
            return ps;
        }
        if (this.ids == null) {
            this.ids = HelperFactory.createInterDiscretizedSteps(steps);
            this.ids.setPreviousFixStep(this.dcs);
            this.ph.getPhysicalSteps().add((Object)this.ids);
        } else {
            this.ids.getCorrespondingLogicalSteps().add((Object)steps);
        }
        return this.ids;
    }

    public int getMaxInterval() {
        int n = 0;
        for (PhysicalSteps ps : this.ph.getPhysicalSteps()) {
            int m;
            if (!(ps instanceof InterDiscretizedSteps) || (m = ((InterDiscretizedSteps)ps).getCorrespondingLogicalSteps().size()) <= n) continue;
            n = m;
        }
        return n;
    }
}

