/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFileUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.IProjectUtils;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.AbstractNewProjectWizardWithTemplates;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.TemplateListSelectionPage;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.WizardElement;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.IProjectContentWizard;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.ProjectTemplateApplicationOperation;
import org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.Activator;
import org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.wizards.GemocProjectFilesTemplates;
import org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.wizards.pages.NewGemocLanguageProjectWizardFields;
import org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.wizards.pages.NewGemocLanguageProjectWizardPage;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.elements.IPDEElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateNewGemocSequentialLanguageProject
extends AbstractNewProjectWizardWithTemplates
implements INewWizard {
    protected NewGemocLanguageProjectWizardFields context = new NewGemocLanguageProjectWizardFields();
    protected NewGemocLanguageProjectWizardPage projectPage;

    public void addPages() {
        super.addPages();
        this.projectPage = new NewGemocLanguageProjectWizardPage(this.context);
        this.projectPage.setDescription("Create a new Gemoc Sequential Language Project");
        this.projectPage.updateNameProject("org.company.mysequentiallanguage.xdsml");
        this.addPage((IWizardPage)this.projectPage);
        this.addPage((IWizardPage)this.getTemplateListSelectionPage(this.context));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            final IProjectDescription description = workspace.newProjectDescription(this.context.projectName);
            if (!this.context.projectLocation.equals(workspace.getRoot().getLocation().toOSString())) {
                description.setLocation((IPath)new Path(this.context.projectLocation));
            }
            final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.context.projectName);
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.create(description, monitor);
                    project.open(monitor);
                    CreateNewGemocSequentialLanguageProject.this.configureProject(project, monitor);
                    IProjectContentWizard contentWizard = CreateNewGemocSequentialLanguageProject.this.templateSelectionPage.getSelectedWizard();
                    try {
                        CreateNewGemocSequentialLanguageProject.this.getContainer().run(false, true, (IRunnableWithProgress)new ProjectTemplateApplicationOperation((BaseProjectWizardFields)CreateNewGemocSequentialLanguageProject.this.context, project, contentWizard));
                    }
                    catch (InvocationTargetException e) {
                        Activator.error(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        Activator.error(e.getMessage(), e);
                    }
                    project.refreshLocal(2, monitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(operation, null);
        }
        catch (Exception exception) {
            Activator.error(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public void configureProject(IProject project, IProgressMonitor monitor) {
        try {
            IProjectUtils.addNature((IProject)project, (String)"org.eclipse.jdt.core.javanature");
            IProjectUtils.addNature((IProject)project, (String)"org.eclipse.xtext.ui.shared.xtextNature");
            IProjectUtils.addNature((IProject)project, (String)"org.eclipse.pde.PluginNature");
            this.createEmptyManifestFile(project, monitor);
            this.updateManifestFile(project, monitor);
            this.createPlugInFile(project, monitor);
            this.createBuildProperties(project, monitor);
            this.setClasspath(project, monitor);
            IProjectUtils.addNature((IProject)project, (String)"org.eclipse.gemoc.xdsmlframework.ide.ui.GemocLanguageProjectNature");
            IProjectUtils.addNature((IProject)project, (String)"org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.GemocSequentialLanguageNature");
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
    }

    private void createEmptyManifestFile(IProject project, IProgressMonitor monitor) throws Exception {
        IFolder metaInf = project.getFolder("META-INF");
        metaInf.create(false, true, monitor);
        String path = "META-INF/MANIFEST.MF";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Manifest-Version: 1.0" + lineSeparator);
        buffer.append("Bundle-ManifestVersion: 2" + lineSeparator);
        buffer.append("Bundle-Name: " + project.getName() + lineSeparator);
        buffer.append("Bundle-SymbolicName: " + project.getName() + "; singleton:=true" + lineSeparator);
        buffer.append("Automatic-Module-Name: " + project.getName() + lineSeparator);
        buffer.append("Bundle-Version: 1.0.0" + lineSeparator);
        buffer.append("Bundle-ClassPath: ." + lineSeparator);
        buffer.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.8" + lineSeparator);
        IFileUtils.writeInFile((IFile)file, (String)buffer.toString(), (IProgressMonitor)monitor);
    }

    private void createBuildProperties(IProject project, IProgressMonitor monitor) throws Exception {
        String path = "build.properties";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = GemocProjectFilesTemplates.getBuildProperties();
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    private void updateManifestFile(IProject project, IProgressMonitor monitor) {
        try {
            ManifestChanger manifestChanger = new ManifestChanger(project.getFile("META-INF/MANIFEST.MF"));
            manifestChanger.addPluginDependency("org.eclipse.xtend.lib", "2.21.0", false, true);
            manifestChanger.addPluginDependency("org.eclipse.xtext.xbase.lib", "2.21.0", false, true);
            manifestChanger.addPluginDependency("com.google.guava", "0.0.0", false, true);
            manifestChanger.addPluginDependency("org.eclipse.emf.ecore.xmi", "2.8.0", true, true);
            manifestChanger.addPluginDependency("org.eclipse.emf.ecore", "2.8.0", true, true);
            manifestChanger.addPluginDependency("org.eclipse.emf.common", "2.8.0", true, true);
            manifestChanger.addPluginDependency("fr.inria.diverse.k3.al.annotationprocessor.plugin");
            manifestChanger.addAttributes("Bundle-ActivationPolicy", "lazy");
            manifestChanger.commit();
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
    }

    private void createPlugInFile(IProject project, IProgressMonitor monitor) throws Exception {
        String path = "/plugin.xml";
        IProject currentContainer = project;
        IFile file = currentContainer.getFile((IPath)new Path(path));
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n</plugin>";
        IFileUtils.writeInFile((IFile)file, (String)contents, (IProgressMonitor)monitor);
    }

    public void setClasspath(IProject project, IProgressMonitor monitor) {
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            IFolder sourceFolder = project.getFolder("src");
            try {
                sourceFolder.create(true, true, monitor);
            }
            catch (Exception exception) {}
            ArrayList<IClasspathEntry> newClassPathArrayList = new ArrayList<IClasspathEntry>();
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)sourceFolder);
            newClassPathArrayList.add(JavaCore.newSourceEntry((IPath)root.getPath()));
            newClassPathArrayList.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER")));
            newClassPathArrayList.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
            IClasspathEntry[] newClassPath = new IClasspathEntry[newClassPathArrayList.size()];
            javaProject.setRawClasspath(newClassPathArrayList.toArray(newClassPath), monitor);
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public ElementList getAvailableCodegenWizards() {
        ElementList superRes = super.getAvailableCodegenWizards();
        ElementList newRes = new ElementList("CodegenWizards");
        Object[] objectArray = superRes.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            WizardElement wizardElem;
            String id;
            Object element = objectArray[n2];
            if (element instanceof WizardElement && (id = (wizardElem = (WizardElement)element).getID()).equals("org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.templates.projectContent.SequentialSingleLanguage")) {
                newRes.add((IPDEElement)wizardElem);
            }
            ++n2;
        }
        return newRes;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        TemplateListSelectionPage templatesPage = this.getTemplateListSelectionPage(this.context);
        templatesPage.setUseTemplate(true);
        templatesPage.selectTemplate("org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.templates.projectContent.SequentialSingleLanguage");
    }

    public String getTargetPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }
}

