/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.treeview;

import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.treeview.DefaultTreeNode;
import org.apache.maven.index.treeview.IndexTreeView;
import org.apache.maven.index.treeview.TreeNode;
import org.apache.maven.index.treeview.TreeNodeFactory;
import org.apache.maven.index.treeview.TreeViewRequest;

public class DefaultTreeNodeFactory
implements TreeNodeFactory {
    private final String repositoryId;

    public DefaultTreeNodeFactory(String id) {
        this.repositoryId = id;
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public TreeNode createGNode(IndexTreeView tview, TreeViewRequest req, String path, String groupName) {
        TreeNode result = this.createNode(tview, req, path, false, groupName, TreeNode.Type.G);
        return this.decorateGNode(tview, req, path, groupName, result);
    }

    protected TreeNode decorateGNode(IndexTreeView tview, TreeViewRequest req, String path, String groupName, TreeNode node) {
        return node;
    }

    @Override
    public TreeNode createANode(IndexTreeView tview, TreeViewRequest req, ArtifactInfo ai, String path) {
        TreeNode result = this.createNode(tview, req, path, false, ai.getArtifactId(), TreeNode.Type.A);
        result.setGroupId(ai.getGroupId());
        result.setArtifactId(ai.getArtifactId());
        return this.decorateANode(tview, req, ai, path, result);
    }

    protected TreeNode decorateANode(IndexTreeView tview, TreeViewRequest req, ArtifactInfo ai, String path, TreeNode node) {
        return node;
    }

    @Override
    public TreeNode createVNode(IndexTreeView tview, TreeViewRequest req, ArtifactInfo ai, String path) {
        TreeNode result = this.createNode(tview, req, path, false, ai.getVersion(), TreeNode.Type.V);
        result.setGroupId(ai.getGroupId());
        result.setArtifactId(ai.getArtifactId());
        result.setVersion(ai.getVersion());
        return this.decorateVNode(tview, req, ai, path, result);
    }

    protected TreeNode decorateVNode(IndexTreeView tview, TreeViewRequest req, ArtifactInfo ai, String path, TreeNode node) {
        return node;
    }

    @Override
    public TreeNode createArtifactNode(IndexTreeView tview, TreeViewRequest req, ArtifactInfo ai, String path) {
        StringBuilder sb = new StringBuilder(ai.getArtifactId()).append("-").append(ai.getVersion());
        if (ai.getClassifier() != null) {
            sb.append("-").append(ai.getClassifier());
        }
        sb.append(".").append(ai.getFileExtension() == null ? "jar" : ai.getFileExtension());
        TreeNode result = this.createNode(tview, req, path, true, sb.toString(), TreeNode.Type.artifact);
        result.setGroupId(ai.getGroupId());
        result.setArtifactId(ai.getArtifactId());
        result.setVersion(ai.getVersion());
        return this.decorateArtifactNode(tview, req, ai, path, result);
    }

    protected TreeNode decorateArtifactNode(IndexTreeView tview, TreeViewRequest req, ArtifactInfo ai, String path, TreeNode node) {
        return node;
    }

    protected TreeNode createNode(IndexTreeView tview, TreeViewRequest req, String path, boolean leaf, String nodeName, TreeNode.Type type) {
        TreeNode result = this.instantiateNode(tview, req, path, leaf, nodeName);
        result.setPath(path);
        result.setType(type);
        result.setLeaf(leaf);
        result.setNodeName(nodeName);
        result.setRepositoryId(this.getRepositoryId());
        return result;
    }

    protected TreeNode instantiateNode(IndexTreeView tview, TreeViewRequest req, String path, boolean leaf, String nodeName) {
        return new DefaultTreeNode(tview, req);
    }
}

