/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.diffviewer.views;

import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExtractor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TraceSectionsDialog
extends TitleAreaDialog {
    private int s1 = -1;
    private int s2 = -1;
    private int e1 = -1;
    private int e2 = -1;
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor1;
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor2;
    private static final Background TRANSPARENT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)});
    private static final Font FONT = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0);

    public TraceSectionsDialog(Shell parentShell, ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor1, ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor2) {
        super(parentShell);
        this.extractor1 = extractor1;
        this.extractor2 = extractor2;
    }

    public void create() {
        super.create();
        this.setTitle("Trace Sections");
        this.setMessage("Enter starting and ending states of trace sections", 1);
    }

    private Shape createCursor() {
        return new Polygon(new double[]{0.0, 7.5, 5.0, 0.0, -5.0, 0.0});
    }

    private Pane createTraceWidget(ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor, String label, ReadOnlyDoubleProperty width) {
        Pane pane = new Pane();
        pane.setBackground(TRANSPARENT_BACKGROUND);
        Rectangle rectangle = new Rectangle(0.0, 0.0, 0.0, 12.0);
        rectangle.setFill((Paint)Color.LIGHTGRAY);
        rectangle.widthProperty().bind((ObservableValue)width.subtract(10));
        rectangle.setArcHeight(12.0);
        rectangle.setArcWidth(12.0);
        Label text = new Label(label);
        text.setTextOverrun(OverrunStyle.ELLIPSIS);
        text.setAlignment(Pos.CENTER);
        text.setMouseTransparent(true);
        text.setTextFill((Paint)Color.WHITE);
        text.setFont(FONT);
        text.setMaxWidth(0.0);
        text.maxWidthProperty().bind((ObservableValue)rectangle.widthProperty());
        StackPane layout = new StackPane();
        layout.getChildren().addAll((Object[])new Node[]{rectangle, text});
        pane.getChildren().add((Object)layout);
        layout.setTranslateY(13.0);
        layout.setTranslateX(5.0);
        pane.setPrefHeight(25.0);
        pane.setMinHeight(25.0);
        pane.setMaxHeight(25.0);
        Shape arrow1 = this.createCursor();
        Shape arrow2 = this.createCursor();
        arrow1.setTranslateX(5.0);
        arrow1.setTranslateY(4.0);
        arrow2.translateXProperty().bind((ObservableValue)rectangle.widthProperty().add(5));
        arrow2.setTranslateY(4.0);
        pane.getChildren().add((Object)arrow1);
        pane.getChildren().add((Object)arrow2);
        return pane;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        FXCanvas fxCanvas = new FXCanvas(container, 0);
        fxCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        VBox vBox = new VBox();
        Scene scene = new Scene((Parent)vBox);
        fxCanvas.setScene(scene);
        vBox.getChildren().add((Object)this.createTraceWidget(this.extractor1, "First Trace", scene.widthProperty()));
        vBox.getChildren().add((Object)this.createTraceWidget(this.extractor2, "Second Trace", scene.widthProperty()));
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public int getS1() {
        return this.s1;
    }

    public int getS2() {
        return this.s2;
    }

    public int getE1() {
        return this.e1;
    }

    public int getE2() {
        return this.e2;
    }
}

