/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.parts.sequence;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositionStep {
    public CompositionStep parent;
    public Object key;
    protected List<CompositionStep> subSteps;
    private boolean visibility;

    public CompositionStep(CompositionStep parent, Object key) {
        this.parent = parent;
        this.key = key;
        this.subSteps = new ArrayList<CompositionStep>();
        this.visibility = true;
    }

    public List<CompositionStep> getSubSteps() {
        return this.subSteps;
    }

    public CompositionStep addStep(Object key) {
        CompositionStep compositionStep = new CompositionStep(this, key);
        this.subSteps.add(compositionStep);
        return compositionStep;
    }

    public CompositionStep removeStep(Object key) {
        for (CompositionStep step : this.subSteps) {
            if (step.key != key) continue;
            this.subSteps.remove(step);
            return this;
        }
        return this;
    }

    public boolean isVisibile() {
        return this.visibility && (this.parent == null || this.parent.isVisibile());
    }

    public void switchVisibilty() {
        this.visibility = !this.visibility;
    }

    public CompositionStep next() {
        if (this.subSteps.isEmpty()) {
            return this.parent.nextOf(this);
        }
        return this.subSteps.get(0);
    }

    protected CompositionStep nextOf(CompositionStep step) {
        if (step == null) {
            return null;
        }
        int index = this.subSteps.indexOf(step);
        if (index >= 0) {
            if (index + 1 < this.subSteps.size()) {
                return this.subSteps.get(index + 1);
            }
            if (this.parent != null) {
                return this.parent.nextOf(this);
            }
            return null;
        }
        return null;
    }

    public CompositionStep before() {
        if (this.parent != null) {
            return this.parent.beforeOf(this);
        }
        return null;
    }

    private CompositionStep beforeOf(CompositionStep step) {
        if (step == null) {
            return null;
        }
        int index = this.subSteps.indexOf(step);
        if (index >= 0) {
            if (index - 1 >= 0) {
                return this.subSteps.get(index - 1);
            }
            if (this.parent != null) {
                return this.parent.beforeOf(this);
            }
            return null;
        }
        return null;
    }

    public void up() {
        if (this.parent != null) {
            this.parent.upStep(this);
        }
    }

    private void upStep(CompositionStep step) {
        int index;
        if (step != null && (index = this.subSteps.indexOf(step)) > 0) {
            this.subSteps.set(index, this.subSteps.get(index - 1));
            this.subSteps.set(index - 1, step);
        }
    }

    public void down() {
        if (this.parent != null) {
            this.parent.downStep(this);
        }
    }

    private void downStep(CompositionStep step) {
        int index;
        if (step != null && (index = this.subSteps.indexOf(step)) < this.subSteps.size() - 1) {
            this.subSteps.set(index, this.subSteps.get(index + 1));
            this.subSteps.set(index + 1, step);
        }
    }

    public void moveTo(CompositionStep newParent) {
        if (newParent != null) {
            this.parent.subSteps.remove(this);
            newParent.subSteps.add(this);
            this.parent = newParent;
        }
    }

    public boolean isVisible(Object key) {
        if (key == this.key) {
            return this.isVisibile();
        }
        for (CompositionStep step : this.subSteps) {
            if (!step.isVisible(key)) continue;
            return true;
        }
        return false;
    }
}

