/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.IDiffLabelDecorator;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultUserProperties;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DiffLabelDecorator
implements IDiffLabelDecorator {
    @Override
    public Color getBackground(Object object_p, Color base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        return base_p;
    }

    protected Image getDecoratedImage(Object object_p, Image base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        Image result = base_p;
        if (node_p != null) {
            EMFDiffMergeUIPlugin.ImageID overlay = this.getImageOverlay(object_p, diffKind_p, side_p, node_p);
            result = node_p.getResourceManager().getOverlayVersion(base_p, overlay);
        }
        return result;
    }

    @Override
    public Font getFont(Object object_p, Font base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        return base_p;
    }

    @Override
    public Color getForeground(Object object_p, Color base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        return base_p;
    }

    @Override
    public Image getImage(Object object_p, Image base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        Image result = base_p;
        if (this.needsIconDecoration(object_p, result, diffKind_p, side_p, node_p)) {
            result = this.getDecoratedImage(object_p, result, diffKind_p, side_p, node_p);
        }
        return result;
    }

    protected EMFDiffMergeUIPlugin.ImageID getImageOverlay(Object object_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        return null;
    }

    protected int getLabelDifferenceNumber(Object object_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        int result = 0;
        if (node_p != null && object_p instanceof IMatch) {
            result = node_p.getCategoryManager().getUIDifferenceNumber((IMatch)object_p);
        }
        return result;
    }

    protected String getLabelPrefix(Object object_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        String result = "";
        if (diffKind_p != null) {
            switch (diffKind_p) {
                case FROM_LEFT: {
                    result = "|> ";
                    break;
                }
                case FROM_LEFT_ADD: {
                    result = "+> ";
                    break;
                }
                case FROM_LEFT_DEL: {
                    result = "-> ";
                    break;
                }
                case FROM_RIGHT: {
                    result = "<| ";
                    break;
                }
                case FROM_RIGHT_ADD: {
                    result = "<+ ";
                    break;
                }
                case FROM_RIGHT_DEL: {
                    result = "<- ";
                    break;
                }
                case CONFLICT: {
                    result = "! ";
                    break;
                }
                case FROM_BOTH: 
                case MODIFIED: {
                    result = "| ";
                    break;
                }
                default: {
                    result = "";
                }
            }
        }
        return result;
    }

    protected StyledString getStyledLabelDifferenceNumber(Object object_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        int diffNb = this.getLabelDifferenceNumber(object_p, diffKind_p, side_p, node_p);
        StyledString result = diffNb > 0 ? new StyledString(" (" + String.valueOf(diffNb) + ")", StyledString.COUNTER_STYLER) : new StyledString();
        return result;
    }

    protected StyledString getStyledLabelPrefix(Object object_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        String rawPrefix = this.getLabelPrefix(object_p, diffKind_p, side_p, node_p);
        StyledString result = new StyledString(rawPrefix, StyledString.COUNTER_STYLER);
        return result;
    }

    @Override
    public CharSequence getText(Object object_p, CharSequence base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        CharSequence result = base_p;
        if (this.needsLabelPrefix(object_p, base_p, diffKind_p, side_p, node_p)) {
            result = this.getStyledLabelPrefix(object_p, diffKind_p, side_p, node_p);
            if (base_p instanceof StyledString) {
                ((StyledString)result).append((StyledString)base_p);
            } else if (result != null) {
                ((StyledString)result).append(base_p.toString());
            }
        }
        if (this.needsLabelDifferenceNumber(object_p, base_p, diffKind_p, side_p, node_p)) {
            StyledString postFix = this.getStyledLabelDifferenceNumber(object_p, diffKind_p, side_p, node_p);
            if (!(result instanceof StyledString)) {
                result = result == null ? new StyledString() : new StyledString(result.toString());
            }
            ((StyledString)result).append(postFix);
        }
        return result;
    }

    @Override
    public String getToolTipText(Object object_p, String base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        return base_p;
    }

    protected boolean isLeftSide(Role side_p, EMFDiffNode node_p) {
        return node_p.getRoleForSide(true) == side_p;
    }

    protected boolean needsIconDecoration(Object object_p, Image base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        return node_p != null && node_p.isUserPropertyTrue(DefaultUserProperties.P_CUSTOM_ICONS) && (side_p == null || !(object_p instanceof IMatch) || !node_p.getCategoryManager().isComparisonPart((IMatch)object_p));
    }

    protected boolean needsLabelDifferenceNumber(Object object_p, CharSequence base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        return object_p instanceof IMatch && side_p == null && (node_p == null || node_p.isUserPropertyTrue(DefaultUserProperties.P_SHOW_DIFFERENCE_NUMBERS));
    }

    protected boolean needsLabelPrefix(Object object_p, CharSequence base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        return side_p == null && node_p != null && node_p.isUserPropertyTrue(DefaultUserProperties.P_CUSTOM_LABELS);
    }
}

