/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.arguments;

import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.arguments.StandardFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.SuperfluousFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class StandardFeatureCallArguments
implements IFeatureCallArguments {
    protected final List<JvmFormalParameter> parameters;
    protected final int receiverFixup;
    protected final List<XExpression> arguments;
    protected final ITypeReferenceOwner owner;
    protected int nextUnprocessedArgument = 0;

    public StandardFeatureCallArguments(List<XExpression> arguments, List<JvmFormalParameter> parameters, boolean hasReceiver, ITypeReferenceOwner owner) {
        this.parameters = parameters;
        this.receiverFixup = hasReceiver ? 1 : 0;
        this.arguments = arguments;
        this.owner = owner;
    }

    @Override
    public boolean hasUnprocessedArguments() {
        return this.nextUnprocessedArgument < this.arguments.size();
    }

    @Override
    public IFeatureCallArgumentSlot getNextUnprocessedArgumentSlot() {
        if (!this.hasUnprocessedArguments()) {
            throw new NoSuchElementException();
        }
        if (this.nextUnprocessedArgument < this.parameters.size()) {
            return new StandardFeatureCallArgumentSlot(this, this.nextUnprocessedArgument);
        }
        return new SuperfluousFeatureCallArgumentSlot(this, this.nextUnprocessedArgument);
    }

    @Override
    public XExpression getArgument(int idx) {
        int fixedIdx = idx - this.receiverFixup;
        if (fixedIdx < 0) {
            return null;
        }
        return this.internalGetArgument(fixedIdx);
    }

    @Override
    public final LightweightTypeReference getDeclaredTypeForLambda(int idx) {
        int fixedIdx = idx - this.receiverFixup;
        if (fixedIdx < 0) {
            return null;
        }
        return this.internalGetParameterTypeForLambda(fixedIdx);
    }

    protected LightweightTypeReference internalGetParameterTypeForLambda(int idx) {
        if (idx >= this.parameters.size() && idx < this.arguments.size()) {
            return null;
        }
        return this.internalGetParameterType(idx);
    }

    @Override
    public int getArgumentCount() {
        return this.arguments.size() + this.receiverFixup;
    }

    @Override
    public boolean hasEmptyTrailingVarArg() {
        return false;
    }

    protected XExpression internalGetArgument(int idx) {
        return this.arguments.get(idx);
    }

    protected LightweightTypeReference internalGetParameterType(int idx) {
        JvmFormalParameter parameter = this.parameters.get(idx);
        return this.toLightweightTypeReference(parameter);
    }

    @Override
    public boolean isProcessed(int argumentIndex) {
        return argumentIndex - this.receiverFixup < this.nextUnprocessedArgument || argumentIndex >= this.getArgumentCount();
    }

    protected void markProcessed(int argumentIndex) {
        this.nextUnprocessedArgument = Math.max(argumentIndex + 1, this.nextUnprocessedArgument);
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmFormalParameter parameter) {
        JvmTypeReference parameterType = parameter.getParameterType();
        if (parameterType == null) {
            return null;
        }
        LightweightTypeReference result = this.owner.toLightweightTypeReference(parameterType);
        return result;
    }

    public String toString() {
        return String.format("%s with %s", this.getClass().getSimpleName(), this.arguments);
    }
}

