/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator.metier;

import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.Coincidence;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.OccurrenceRelation;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.Packet;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.Precedence;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.relation.IDescription;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;

public class Description
implements IDescription {
    protected final IDescription.Type type;
    protected final ModelElementReference[] clock;
    protected final boolean strict;
    protected final CCSLConstraintRef source;
    String uid = null;

    public static Description createDescriptionCoincidence(ModelElementReference eo1, ModelElementReference eo2, CCSLConstraintRef cref) {
        return new Description(IDescription.Type.coincidence, new ModelElementReference[]{eo1, eo2}, true, cref);
    }

    public static Description createDescriptionPrecede(ModelElementReference eo1, ModelElementReference eo2, boolean strictly, CCSLConstraintRef cref) {
        return new Description(IDescription.Type.precedence, new ModelElementReference[]{eo1, eo2}, strictly, cref);
    }

    public static Description createDescriptionPacket(ModelElementReference eo1, CCSLConstraintRef cref) {
        return new Description(IDescription.Type.packet, new ModelElementReference[]{eo1}, true, cref);
    }

    public CCSLConstraintRef getRelationConstraint() {
        return this.source;
    }

    private Description(IDescription.Type type, ModelElementReference[] clock, boolean strict, CCSLConstraintRef cref) {
        assert (cref != null);
        assert (type != null);
        assert (clock != null);
        ModelElementReference[] modelElementReferenceArray = clock;
        int n = clock.length;
        int n2 = 0;
        while (n2 < n) {
            ModelElementReference eo = modelElementReferenceArray[n2];
            assert (eo != null);
            ++n2;
        }
        this.type = type;
        this.clock = clock;
        this.strict = strict;
        this.source = cref;
    }

    public final IDescription.Type getType() {
        return this.type;
    }

    public final EObject[] getClock() {
        return (EObject[])this.clock.clone();
    }

    public final boolean isStrict() {
        return this.strict;
    }

    protected boolean checkEventOcurrence(EventOccurrence src, ModelElementReference eo) {
        if (src.getReferedElement() instanceof ModelElementReference) {
            ModelElementReference mer = (ModelElementReference)src.getReferedElement();
            if (mer == eo) {
                return true;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean check(EObject eo) {
        if (eo instanceof OccurrenceRelation) {
            return this.checkOccurrenceRelation((OccurrenceRelation)eo);
        }
        return false;
    }

    public boolean checkOccurrenceRelation(OccurrenceRelation oc) {
        if (oc == null) {
            return false;
        }
        if (oc.eContainer() != null && this.source != null && oc.eContainer() != this.source) {
            return false;
        }
        switch (this.type) {
            case coincidence: {
                if (oc instanceof Coincidence) {
                    Coincidence c = (Coincidence)oc;
                    for (EventOccurrence ev : c.getCoincidentOccurrences()) {
                        boolean b = false;
                        ModelElementReference[] modelElementReferenceArray = this.clock;
                        int n = this.clock.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ModelElementReference e = modelElementReferenceArray[n2];
                            if (this.checkEventOcurrence(ev, e)) {
                                b = true;
                            }
                            ++n2;
                        }
                        if (b) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            case precedence: {
                if (oc instanceof Precedence) {
                    Precedence p = (Precedence)oc;
                    ModelElementReference e0 = this.clock[0];
                    ModelElementReference e1 = this.clock[1];
                    EventOccurrence src = p.getSource();
                    EventOccurrence trg = p.getTarget();
                    if (!this.checkEventOcurrence(src, e0)) {
                        return false;
                    }
                    if (!this.checkEventOcurrence(trg, e1)) {
                        return false;
                    }
                    return p.isIsStrict() == this.strict;
                }
                return false;
            }
            case packet: {
                if (!(oc instanceof Packet)) break;
                Packet p = (Packet)oc;
                for (EventOccurrence eo : p.getOccurrences()) {
                    if (this.checkEventOcurrence(eo, this.clock[0])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getID() {
        if (this.uid == null) {
            StringBuilder sb = new StringBuilder("");
            switch (this.type) {
                case coincidence: {
                    sb.append("C");
                    break;
                }
                case precedence: {
                    sb.append("P");
                    if (this.strict) {
                        sb.append("s");
                        break;
                    }
                    sb.append("W");
                    break;
                }
                case packet: {
                    sb.append("G");
                }
            }
            sb.append("[");
            sb.append(AdapterRegistry.getAdapter((EObject)this.getCcslConstraint()).getUID(this.getCcslConstraint()));
            sb.append("]");
            String[] s = new String[this.clock.length];
            int i = 0;
            while (i < this.clock.length) {
                s[i] = AdapterRegistry.getAdapter((EObject)this.clock[i]).getUID((EObject)this.clock[i]);
                ++i;
            }
            switch (this.type) {
                case precedence: 
                case coincidence: {
                    sb.append("{[");
                    sb.append(s[0]);
                    sb.append("],[");
                    sb.append(s[1]);
                    sb.append("]}");
                    break;
                }
                case packet: {
                    sb.append("{[");
                    sb.append(s[0]);
                    sb.append("]}");
                }
            }
            this.uid = sb.toString();
        }
        return this.uid;
    }

    public EObject getCcslConstraint() {
        return this.source.getCcslConstraint();
    }

    public String getBaseInfo() {
        if (this.source == null) {
            return "..";
        }
        String rule = AdapterRegistry.getAdapter((EObject)this.source.getCcslConstraint()).getReferenceName((EObject)this.source.getCcslConstraint());
        if (rule == null) {
            rule = "";
        }
        return rule;
    }

    public String getSubInfo() {
        if (this.clock == null) {
            return "..";
        }
        String[] s = new String[this.clock.length];
        int i = 0;
        while (i < this.clock.length) {
            s[i] = AdapterRegistry.getAdapter((EObject)this.clock[i]).getReferenceName((EObject)this.clock[i]);
            ++i;
        }
        switch (this.type) {
            case coincidence: {
                return "Coincidence :" + s[0] + " and " + s[1] + " ;";
            }
            case precedence: {
                String tmp = this.strict ? " < " : " <= ";
                return "Precedence :" + s[0] + tmp + s[1] + " ;";
            }
            case packet: {
                return "Packet : " + s[0] + " ;";
            }
        }
        return "";
    }

    public String toString() {
        if (this.source.getCcslConstraint() != null) {
            return String.valueOf(this.getBaseInfo()) + "=>" + this.getSubInfo();
        }
        return this.getSubInfo();
    }

    public int hashCode() {
        this.getID();
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.clock);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.strict ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.getID();
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Description other = (Description)obj;
        other.getID();
        if (!Arrays.equals(this.clock, other.clock)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.strict != other.strict) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }
}

