/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.TextProcessor;

public class BasicElementLabels {
    private BasicElementLabels() {
    }

    private static String markLTR(String string, String delimiters) {
        return TextProcessor.process((String)string, (String)delimiters);
    }

    public static String getPathLabel(IPath path, boolean isOSPath) {
        String label = isOSPath ? path.toOSString() : path.makeRelative().toString();
        return BasicElementLabels.markLTR(label, "/\\:.");
    }

    public static String getFilePattern(String name) {
        return BasicElementLabels.markLTR(name, "*.?/\\:.");
    }

    public static String getURLPart(String name) {
        return BasicElementLabels.markLTR(name, ":@?-#/\\:.");
    }

    public static String getResourceName(IResource resource) {
        return BasicElementLabels.markLTR(resource.getName(), "/\\:.");
    }

    public static String getVersionName(String name) {
        return BasicElementLabels.markLTR(name, ":.");
    }
}

