/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.grammar.Grammar;
import org.eclipse.tm4e.core.internal.grammar.ScopeMetadata;
import org.eclipse.tm4e.core.internal.grammar.StackElementMetadata;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElementRule;

public final class ScopeListElement {
    private static final Splitter BY_SPACE_SPLITTER = Splitter.on((char)' ');
    private final @Nullable ScopeListElement parent;
    private final String scope;
    final int metadata;

    public ScopeListElement(@Nullable ScopeListElement parent, String scope, int metadata) {
        this.parent = parent;
        this.scope = scope;
        this.metadata = metadata;
    }

    private static boolean structuralEquals(@Nullable ScopeListElement a, @Nullable ScopeListElement b) {
        while (a != b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (!Objects.equals(a.scope, b.scope) || a.metadata != b.metadata) {
                return false;
            }
            a = a.parent;
            b = b.parent;
        }
        return true;
    }

    private static boolean equals(@Nullable ScopeListElement a, @Nullable ScopeListElement b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return ScopeListElement.structuralEquals(a, b);
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || other.getClass() != ScopeListElement.class) {
            return false;
        }
        return ScopeListElement.equals(this, (ScopeListElement)other);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.scope, this.metadata);
    }

    private static boolean matchesScope(String scope, String selector, String selectorWithDot) {
        return selector.equals(scope) || scope.startsWith(selectorWithDot);
    }

    private static boolean matches(@Nullable ScopeListElement target, @Nullable List<String> parentScopes) {
        if (parentScopes == null || parentScopes.isEmpty()) {
            return true;
        }
        if (target == null) {
            return false;
        }
        block0: for (String selector : parentScopes) {
            String selectorWithDot = String.valueOf(selector) + '.';
            while (target != null) {
                if (ScopeListElement.matchesScope(target.scope, selector, selectorWithDot)) continue block0;
                target = target.parent;
            }
            return false;
        }
        return true;
    }

    public static int mergeMetadata(int metadata, @Nullable ScopeListElement scopesList, @Nullable ScopeMetadata source) {
        if (source == null) {
            return metadata;
        }
        int fontStyle = -1;
        int foreground = 0;
        int background = 0;
        if (source.themeData != null) {
            for (ThemeTrieElementRule themeData : source.themeData) {
                if (!ScopeListElement.matches(scopesList, themeData.parentScopes)) continue;
                fontStyle = themeData.fontStyle;
                foreground = themeData.foreground;
                background = themeData.background;
                break;
            }
        }
        return StackElementMetadata.set(metadata, source.languageId, source.tokenType, null, fontStyle, foreground, background);
    }

    private static ScopeListElement push(ScopeListElement target, Grammar grammar, Iterable<String> scopes) {
        for (String scope : scopes) {
            ScopeMetadata rawMetadata = grammar.getMetadataForScope(scope);
            int metadata = ScopeListElement.mergeMetadata(target.metadata, target, rawMetadata);
            target = new ScopeListElement(target, scope, metadata);
        }
        return target;
    }

    ScopeListElement push(Grammar grammar, @Nullable String scope) {
        if (scope == null) {
            return this;
        }
        return ScopeListElement.push(this, grammar, BY_SPACE_SPLITTER.split((CharSequence)scope));
    }

    private static List<String> generateScopes(@Nullable ScopeListElement scopesList) {
        ArrayList<String> result = new ArrayList<String>();
        while (scopesList != null) {
            result.add(scopesList.scope);
            scopesList = scopesList.parent;
        }
        Collections.reverse(result);
        return result;
    }

    List<String> generateScopes() {
        return ScopeListElement.generateScopes(this);
    }
}

