/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IToken;
import org.eclipse.tm4e.core.internal.grammar.BalancedBracketSelectors;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.grammar.StackElement;
import org.eclipse.tm4e.core.internal.grammar.StackElementMetadata;
import org.eclipse.tm4e.core.internal.grammar.Token;
import org.eclipse.tm4e.core.internal.grammar.TokenTypeMatcher;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

final class LineTokens {
    private static final System.Logger LOGGER = System.getLogger(LineTokens.class.getName());
    private static final Deque<IToken> EMPTY_DEQUE = new ArrayDeque<IToken>(0);
    private final @Nullable String lineText;
    private final Deque<IToken> tokens;
    private final boolean emitBinaryTokens;
    private final List<Integer> binaryTokens;
    private int lastTokenEndIndex = 0;
    private final List<TokenTypeMatcher> tokenTypeOverrides;
    private final @Nullable BalancedBracketSelectors balancedBracketSelectors;

    LineTokens(boolean emitBinaryTokens, String lineText, List<TokenTypeMatcher> tokenTypeOverrides, @Nullable BalancedBracketSelectors balancedBracketSelectors) {
        this.emitBinaryTokens = emitBinaryTokens;
        String string = this.lineText = LOGGER.isLoggable(System.Logger.Level.TRACE) ? lineText : null;
        if (this.emitBinaryTokens) {
            this.tokens = EMPTY_DEQUE;
            this.binaryTokens = new ArrayList<Integer>();
        } else {
            this.tokens = new ArrayDeque<IToken>();
            this.binaryTokens = Collections.emptyList();
        }
        this.tokenTypeOverrides = tokenTypeOverrides;
        this.balancedBracketSelectors = balancedBracketSelectors;
    }

    void produce(StackElement stack, int endIndex) {
        this.produceFromScopes(stack.contentNameScopesList, endIndex);
    }

    void produceFromScopes(ScopeListElement scopesList, int endIndex) {
        if (this.lastTokenEndIndex >= endIndex) {
            return;
        }
        if (this.emitBinaryTokens) {
            List<String> scopes;
            int metadata = scopesList.metadata;
            boolean containsBalancedBrackets = false;
            BalancedBracketSelectors balancedBracketSelectors = this.balancedBracketSelectors;
            if (balancedBracketSelectors != null && balancedBracketSelectors.matchesAlways()) {
                containsBalancedBrackets = true;
            }
            if (!this.tokenTypeOverrides.isEmpty() || balancedBracketSelectors != null && !balancedBracketSelectors.matchesAlways() && !balancedBracketSelectors.matchesNever()) {
                scopes = scopesList.generateScopes();
                for (TokenTypeMatcher tokenType : this.tokenTypeOverrides) {
                    if (!tokenType.getMatcher().matches(scopes)) continue;
                    metadata = StackElementMetadata.set(metadata, 0, tokenType.getType(), null, -1, 0, 0);
                }
                if (balancedBracketSelectors != null) {
                    containsBalancedBrackets = balancedBracketSelectors.match(scopes);
                }
            }
            if (containsBalancedBrackets) {
                metadata = StackElementMetadata.set(metadata, 0, 8, containsBalancedBrackets, -1, 0, 0);
            }
            if (!this.binaryTokens.isEmpty() && MoreCollections.getLastElement(this.binaryTokens) == metadata) {
                this.lastTokenEndIndex = endIndex;
                return;
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                scopes = scopesList.generateScopes();
                LOGGER.log(System.Logger.Level.TRACE, "  token: |" + NullSafetyHelper.castNonNull(this.lineText).substring(this.lastTokenEndIndex >= 0 ? this.lastTokenEndIndex : 0, endIndex).replace("\n", "\\n") + '|');
                for (String scope : scopes) {
                    LOGGER.log(System.Logger.Level.TRACE, "      * " + scope);
                }
            }
            this.binaryTokens.add(this.lastTokenEndIndex);
            this.binaryTokens.add(metadata);
            this.lastTokenEndIndex = endIndex;
            return;
        }
        List<String> scopes = scopesList.generateScopes();
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "  token: |" + NullSafetyHelper.castNonNull(this.lineText).substring(this.lastTokenEndIndex >= 0 ? this.lastTokenEndIndex : 0, endIndex).replace("\n", "\\n") + '|');
            for (String scope : scopes) {
                LOGGER.log(System.Logger.Level.TRACE, "      * " + scope);
            }
        }
        this.tokens.add(new Token(this.lastTokenEndIndex >= 0 ? this.lastTokenEndIndex : 0, endIndex, scopes));
        this.lastTokenEndIndex = endIndex;
    }

    IToken[] getResult(StackElement stack, int lineLength) {
        if (!this.tokens.isEmpty() && this.tokens.getLast().getStartIndex() == lineLength - 1) {
            this.tokens.removeLast();
        }
        if (this.tokens.isEmpty()) {
            this.lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this.tokens.getLast().setStartIndex(0);
        }
        return (IToken[])this.tokens.toArray(IToken[]::new);
    }

    int[] getBinaryResult(StackElement stack, int lineLength) {
        if (!this.binaryTokens.isEmpty() && this.binaryTokens.get(this.binaryTokens.size() - 2) == lineLength - 1) {
            MoreCollections.removeLastElement(this.binaryTokens);
            MoreCollections.removeLastElement(this.binaryTokens);
        }
        if (this.binaryTokens.isEmpty()) {
            this.lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this.binaryTokens.set(this.binaryTokens.size() - 2, 0);
        }
        return this.binaryTokens.stream().mapToInt(Integer::intValue).toArray();
    }
}

