/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;

final class ThemeAssociationRegistry {
    private final Map<@Nullable String, @Nullable EclipseThemeAssociation> scopes = new HashMap<String, EclipseThemeAssociation>();

    ThemeAssociationRegistry() {
    }

    @Nullable IThemeAssociation getThemeAssociationFor(String scopeName, boolean dark) {
        IThemeAssociation userAssociation = null;
        EclipseThemeAssociation registry = this.scopes.get(scopeName);
        if (registry != null) {
            IThemeAssociation iThemeAssociation = userAssociation = dark ? registry.dark : registry.light;
        }
        if (userAssociation != null) {
            return userAssociation;
        }
        return null;
    }

    void register(IThemeAssociation association) {
        boolean dark;
        String scopeName = association.getScopeName();
        EclipseThemeAssociation registry = this.scopes.get(scopeName);
        if (registry == null) {
            registry = new EclipseThemeAssociation();
            this.scopes.put(scopeName, registry);
        }
        if (dark = association.isWhenDark()) {
            registry.dark = association;
        } else {
            registry.light = association;
        }
    }

    void unregister(IThemeAssociation association) {
        String scopeName = association.getScopeName();
        EclipseThemeAssociation registry = this.scopes.get(scopeName);
        if (registry != null) {
            boolean dark = association.isWhenDark();
            if (dark) {
                registry.dark = null;
            } else {
                registry.light = null;
            }
        }
    }

    List<IThemeAssociation> getThemeAssociations() {
        ArrayList<IThemeAssociation> associations = new ArrayList<IThemeAssociation>();
        Collection<EclipseThemeAssociation> eclipseAssociations = this.scopes.values();
        for (EclipseThemeAssociation eclipseAssociation : eclipseAssociations) {
            if (eclipseAssociation == null) continue;
            if (eclipseAssociation.light != null) {
                associations.add(eclipseAssociation.light);
            }
            if (eclipseAssociation.dark == null) continue;
            associations.add(eclipseAssociation.dark);
        }
        return associations;
    }

    private static final class EclipseThemeAssociation {
        @Nullable IThemeAssociation light;
        @Nullable IThemeAssociation dark;

        private EclipseThemeAssociation() {
        }
    }
}

