/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.export.AbstractExporter;
import org.eclipse.ocl.examples.emf.validation.validity.messages.ValidityMessages;

public class TextExporter
extends AbstractExporter {
    public static final @NonNull String EXPORTER_TYPE = "text";
    public static final @NonNull TextExporter INSTANCE = new TextExporter();

    private void appendLogFile(LeafConstrainingNode node, @NonNull Appendable s, String severity) throws IOException {
        Resource resource = node.getConstraintResource();
        if (resource != null) {
            s.append("\t\t\t Resource: " + resource.getURI() + "\n");
        } else {
            s.append("\t\t\t Resource: " + ValidityMessages.ValidityView_Constraints_LabelProvider_NonExistentResource + "\n");
        }
        s.append("\t\t\t Invariant: " + node.getLabel() + "\n");
        String expression = node.getConstraintString();
        if (expression != null) {
            s.append("\t\t\t Expression: " + expression + "\n");
        } else {
            s.append("\t\t\t Expression: " + ValidityMessages.ValidityView_Constraints_LabelProvider_ExpressionNotAvailable + "\n");
        }
        s.append("\t\t\t Severity: " + severity + "\n");
        s.append("\t\t\t Message: " + this.getMessage(node.getWorstResult()) + "\n");
        s.append("\t\t\t\t-------------\n");
    }

    @Override
    public void createContents(@NonNull Appendable text, @NonNull RootNode rootNode, @Nullable String exportedFileName) throws IOException {
        text.append("==== GENERAL INFORMATION ====\n");
        if (exportedFileName != null) {
            text.append("Output file name: " + exportedFileName + "\n");
        }
        text.append("Author: " + System.getProperty("user.name") + "\n");
        text.append("\n");
        text.append("\n");
        text.append("==== RESOURCES USED ====\n");
        text.append("Model checked: \n");
        ArrayList<String> uriStrings = new ArrayList<String>();
        for (RootValidatableNode rootValidatableNode : rootNode.getValidatableNodes()) {
            Resource eResource = rootValidatableNode.getConstrainedObject().eResource();
            uriStrings.add(eResource.getURI().toString());
        }
        Collections.sort(uriStrings);
        for (String uriString : uriStrings) {
            text.append("\t\t\t\t" + uriString + "\n");
        }
        text.append("\n");
        text.append("\n");
        text.append("==== METRICS ====\n");
        int total = this.getConstraintCount();
        text.append("Total number of evaluated constraints: " + total + "\n");
        text.append("- Number of Success: " + this.validationSuccess.size() + "\n");
        text.append("- Number of Infos: " + this.validationInfos.size() + "\n");
        text.append("- Number of Warnings: " + this.validationWarnings.size() + "\n");
        text.append("- Number of Errors: " + this.validationErrors.size() + "\n");
        text.append("- Number of Failures: " + this.validationFailures.size() + "\n");
        text.append("\n");
        text.append("\n");
        text.append("==== LOGS ====\n");
        if (this.validationSuccess.size() == total) {
            text.append("No log to display: models has been successfully validated.\n");
        } else {
            HashSet<Object> loggedConstrainingObjects = new HashSet<Object>();
            if (!this.validationInfos.isEmpty()) {
                text.append("- Informations:\n");
                for (LeafConstrainingNode infoNode : this.validationInfos) {
                    if (!loggedConstrainingObjects.add(infoNode.getConstrainingObject())) continue;
                    this.appendLogFile(infoNode, text, Severity.INFO.getLiteral());
                }
            }
            if (!this.validationWarnings.isEmpty()) {
                text.append("- Warnings:\n");
                for (LeafConstrainingNode warningNode : this.validationWarnings) {
                    if (!loggedConstrainingObjects.add(warningNode.getConstrainingObject())) continue;
                    this.appendLogFile(warningNode, text, Severity.WARNING.getLiteral());
                }
            }
            if (!this.validationErrors.isEmpty()) {
                text.append("- Errors:\n");
                for (LeafConstrainingNode errorNode : this.validationErrors) {
                    if (!loggedConstrainingObjects.add(errorNode.getConstrainingObject())) continue;
                    this.appendLogFile(errorNode, text, Severity.ERROR.getLiteral());
                }
            }
            if (!this.validationFailures.isEmpty()) {
                text.append("- Failures:\n");
                for (LeafConstrainingNode failureNode : this.validationFailures) {
                    if (!loggedConstrainingObjects.add(failureNode.getConstrainingObject())) continue;
                    this.appendLogFile(failureNode, text, Severity.FATAL.getLiteral());
                }
            }
        }
    }

    @Override
    public @NonNull String getExporterType() {
        return EXPORTER_TYPE;
    }

    @Override
    public @NonNull String getPreferredExtension() {
        return "txt";
    }
}

