/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.spy.context;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.spy.context.ContextDataFilter;
import org.eclipse.pde.internal.spy.context.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ContextDataProvider
extends ColumnLabelProvider
implements ITreeContentProvider {
    private static final String NO_VALUE_COULD_BE_COMPUTED = Messages.ContextDataProvider_0;
    private static final Color COLOR_IF_FOUND = Display.getCurrent().getSystemColor(9);
    private static final Color COLOR_IF_NOT_COMPUTED = Display.getCurrent().getSystemColor(11);
    private static final Object[] EMPTY_RESULT = new Object[0];
    static final String LOCAL_VALUE_NODE = Messages.ContextDataProvider_1;
    static final String INHERITED_INJECTED_VALUE_NODE = Messages.ContextDataProvider_2;
    private static final String NO_VALUES_FOUND = Messages.ContextDataProvider_3;
    private static final String UPDATED_IN_CLASS = Messages.ContextDataProvider_4;
    private static final String INJECTED_IN_FIELD = Messages.ContextDataProvider_5;
    private static final String INJECTED_IN_METHOD = Messages.ContextDataProvider_6;
    private static final String PUBLIC_METHOD_IMG_KEY = "icons/methpub_obj.png";
    private static final String PUBLIC_FIELD_IMG_KEY = "icons/field_public_obj.png";
    private static final String VALUE_IN_CONTEXT_IMG_KEY = "icons/valueincontext.png";
    private static final String INHERITED_VARIABLE_IMG_KEY = "icons/inher_co.png";
    private static final String LOCAL_VARIABLE_IMG_KEY = "icons/letter-l-icon.png";
    private static final String CONTEXT_FUNCTION_IMG_KEY = "icons/contextfunction.png";
    private static final String INJECT_IMG_KEY = "icons/annotation_obj.png";
    private ImageRegistry imgReg;
    @Inject
    private ContextDataFilter contextFilter;
    private static EclipseContext selectedContext;
    private Font boldFont;
    private boolean displayKey = false;

    @Inject
    public ContextDataProvider() {
        this.initFonts();
        this.initializeImageRegistry();
    }

    public void dispose() {
        selectedContext = null;
        this.imgReg = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        selectedContext = newInput instanceof EclipseContext ? (EclipseContext)newInput : null;
    }

    public Object[] getElements(Object inputElement) {
        return new String[]{LOCAL_VALUE_NODE, INHERITED_INJECTED_VALUE_NODE};
    }

    public Object[] getChildren(Object inputElement) {
        if (selectedContext == null) {
            return EMPTY_RESULT;
        }
        if (inputElement == LOCAL_VALUE_NODE) {
            ArrayList result = new ArrayList();
            result.addAll(selectedContext.localData().entrySet());
            HashMap<String, Object> cfValues = new HashMap<String, Object>();
            for (String key : selectedContext.localContextFunction().keySet()) {
                try {
                    cfValues.put(key, selectedContext.get(key));
                }
                catch (Exception e) {
                    cfValues.put(key, String.valueOf(NO_VALUE_COULD_BE_COMPUTED) + " (Exception : " + e.getClass().getName() + ")");
                }
            }
            result.addAll(cfValues.entrySet());
            return result.toArray();
        }
        if (inputElement == INHERITED_INJECTED_VALUE_NODE) {
            Object[] objectArray;
            ArrayList<String> result = new ArrayList<String>();
            Set localKeys = selectedContext.localData().keySet();
            Set localContextFunctionsKeys = selectedContext.localContextFunction().keySet();
            if (selectedContext.getRawListenerNames() != null) {
                for (String name : selectedContext.getRawListenerNames()) {
                    if (localKeys.contains(name) || localContextFunctionsKeys.contains(name)) continue;
                    result.add(name);
                }
            }
            if (result.isEmpty()) {
                String[] stringArray = new String[1];
                objectArray = stringArray;
                stringArray[0] = NO_VALUES_FOUND;
            } else {
                objectArray = result.toArray();
            }
            return objectArray;
        }
        if (inputElement instanceof Map.Entry) {
            Set<Computation> listeners = this.getListeners(inputElement);
            return listeners == null ? null : listeners.toArray();
        }
        if (inputElement instanceof String) {
            return selectedContext.getListeners((String)inputElement).toArray();
        }
        return EMPTY_RESULT;
    }

    public void setDisplayKey(boolean k) {
        this.displayKey = k;
    }

    public String getText(Object element) {
        if (selectedContext == null) {
            return null;
        }
        if (element instanceof Map.Entry) {
            Map.Entry mapEntry = (Map.Entry)element;
            Object o = this.displayKey ? mapEntry.getKey() : mapEntry.getValue();
            return o == null ? Messages.ContextDataProvider_16 : o.toString();
        }
        if (element instanceof Computation) {
            String txt = super.getText(element);
            if (this.displayKey) {
                if (txt.contains("#")) {
                    return INJECTED_IN_METHOD;
                }
                if (txt.contains("@")) {
                    return UPDATED_IN_CLASS;
                }
                return INJECTED_IN_FIELD;
            }
            return txt;
        }
        return this.displayKey ? super.getText(element) : null;
    }

    public Color getForeground(Object element) {
        String s = this.getText(element);
        if (s != null && s.startsWith(NO_VALUE_COULD_BE_COMPUTED)) {
            return COLOR_IF_NOT_COMPUTED;
        }
        return this.contextFilter.matchText(s) ? COLOR_IF_FOUND : null;
    }

    public Font getFont(Object element) {
        return element == LOCAL_VALUE_NODE || element == INHERITED_INJECTED_VALUE_NODE ? this.boldFont : null;
    }

    public Image getImage(Object element) {
        if (!this.displayKey) {
            return null;
        }
        if (element == LOCAL_VALUE_NODE) {
            return selectedContext == null ? null : this.imgReg.get(LOCAL_VARIABLE_IMG_KEY);
        }
        if (element == INHERITED_INJECTED_VALUE_NODE) {
            return selectedContext == null ? null : this.imgReg.get(INHERITED_VARIABLE_IMG_KEY);
        }
        if (element instanceof Computation) {
            String txt = super.getText(element);
            if (txt.contains("#")) {
                return this.imgReg.get(PUBLIC_METHOD_IMG_KEY);
            }
            if (txt.contains("@")) {
                return this.imgReg.get(CONTEXT_FUNCTION_IMG_KEY);
            }
            return this.imgReg.get(PUBLIC_FIELD_IMG_KEY);
        }
        if (element instanceof Map.Entry) {
            if (this.isAContextKeyFunction(element)) {
                return this.imgReg.get(CONTEXT_FUNCTION_IMG_KEY);
            }
            return this.hasChildren(element) ? this.imgReg.get(INJECT_IMG_KEY) : this.imgReg.get(VALUE_IN_CONTEXT_IMG_KEY);
        }
        return this.imgReg.get(INJECT_IMG_KEY);
    }

    public String getToolTipText(Object element) {
        if (element == LOCAL_VALUE_NODE) {
            return String.valueOf(Messages.ContextDataProvider_21) + Messages.ContextDataProvider_22 + Messages.ContextDataProvider_23;
        }
        if (element == INHERITED_INJECTED_VALUE_NODE) {
            return String.valueOf(Messages.ContextDataProvider_24) + Messages.ContextDataProvider_25;
        }
        if (this.isAContextKeyFunction(element)) {
            String key = (String)((Map.Entry)element).getKey();
            String fname = selectedContext.localContextFunction().get(key).getClass().getCanonicalName();
            return String.valueOf(Messages.ContextDataProvider_26) + fname;
        }
        if (this.hasChildren(element)) {
            return Messages.ContextDataProvider_27;
        }
        if (element instanceof Map.Entry) {
            return Messages.ContextDataProvider_28;
        }
        return super.getToolTipText(element);
    }

    public Image getToolTipImage(Object object) {
        return this.getImage(object);
    }

    public int getToolTipStyle(Object object) {
        return 8;
    }

    boolean isAContextKeyFunction(Object element) {
        if (selectedContext != null && element instanceof Map.Entry) {
            Map.Entry mapEntry = (Map.Entry)element;
            return selectedContext.localContextFunction().containsKey(mapEntry.getKey());
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element == LOCAL_VALUE_NODE || element == INHERITED_INJECTED_VALUE_NODE) {
            return null;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == INHERITED_INJECTED_VALUE_NODE || element == LOCAL_VALUE_NODE) {
            return true;
        }
        Set<Computation> listeners = this.getListeners(element);
        return listeners != null && !listeners.isEmpty();
    }

    Set<Computation> getListeners(Object element) {
        if (selectedContext != null) {
            if (element instanceof Map.Entry) {
                Map.Entry mapEntry = (Map.Entry)element;
                String key = (String)mapEntry.getKey();
                return selectedContext.getListeners(key);
            }
            if (element instanceof String) {
                return selectedContext.getListeners((String)element);
            }
        }
        return null;
    }

    private void initializeImageRegistry() {
        Bundle b = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        this.imgReg = new ImageRegistry();
        this.imgReg.put(CONTEXT_FUNCTION_IMG_KEY, ImageDescriptor.createFromURL((URL)b.getEntry(CONTEXT_FUNCTION_IMG_KEY)));
        this.imgReg.put(INJECT_IMG_KEY, ImageDescriptor.createFromURL((URL)b.getEntry(INJECT_IMG_KEY)));
        this.imgReg.put(PUBLIC_METHOD_IMG_KEY, ImageDescriptor.createFromURL((URL)b.getEntry(PUBLIC_METHOD_IMG_KEY)));
        this.imgReg.put(PUBLIC_FIELD_IMG_KEY, ImageDescriptor.createFromURL((URL)b.getEntry(PUBLIC_FIELD_IMG_KEY)));
        this.imgReg.put(PUBLIC_FIELD_IMG_KEY, ImageDescriptor.createFromURL((URL)b.getEntry(PUBLIC_FIELD_IMG_KEY)));
        this.imgReg.put(LOCAL_VARIABLE_IMG_KEY, ImageDescriptor.createFromURL((URL)b.getEntry(LOCAL_VARIABLE_IMG_KEY)));
        this.imgReg.put(VALUE_IN_CONTEXT_IMG_KEY, ImageDescriptor.createFromURL((URL)b.getEntry(VALUE_IN_CONTEXT_IMG_KEY)));
        this.imgReg.put(INHERITED_VARIABLE_IMG_KEY, ImageDescriptor.createFromURL((URL)b.getEntry(INHERITED_VARIABLE_IMG_KEY)));
    }

    private void initFonts() {
        FontData[] fontData = Display.getCurrent().getSystemFont().getFontData();
        String fontName = fontData[0].getName();
        FontRegistry registry = JFaceResources.getFontRegistry();
        this.boldFont = registry.getBold(fontName);
    }
}

