/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.lightccsl.core.stepper;

import fr.kairos.lightccsl.core.stepper.IClock;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class Clock
implements IClock {
    private int history = 0;
    private LinkedList<Integer> trace = new LinkedList();
    private LinkedList<Integer> ghosts = new LinkedList();
    private int lastCurrent = 0;

    @Override
    public Clock clone() {
        int i;
        Clock res = new Clock();
        res.history = this.history;
        res.lastCurrent = this.lastCurrent;
        Iterator iterator = this.trace.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            res.trace.add(i);
        }
        iterator = this.ghosts.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            res.ghosts.add(i);
        }
        return res;
    }

    @Override
    public int getHistory(int step) {
        int tick = 0;
        Iterator iterator = this.trace.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i < step) {
                ++tick;
                continue;
            }
            return tick;
        }
        return tick;
    }

    @Override
    public int getHistory() {
        return this.history;
    }

    @Override
    public boolean isTicking() {
        return !this.trace.isEmpty() && this.trace.getLast() == this.lastCurrent;
    }

    @Override
    public boolean wasTicking(int step) {
        return this.trace.contains(step);
    }

    @Override
    public int previous(int nb) {
        ListIterator<Integer> it = this.trace.listIterator(this.trace.size());
        int i = 0;
        while (i < nb) {
            if (!it.hasPrevious()) {
                return -1;
            }
            it.previous();
            ++i;
        }
        if (it.hasPrevious()) {
            return it.previous();
        }
        return -1;
    }

    @Override
    public void tick(int current) {
        ++this.history;
        this.trace.add(current);
        this.lastCurrent = current;
    }

    public CharSequence toString(int nbStep) {
        StringBuilder sb = new StringBuilder();
        int last = -1;
        Iterator iterator = this.trace.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i > nbStep) break;
            int j = last + 1;
            while (j < i) {
                sb.append("   ");
                ++j;
            }
            sb.append("  x");
            last = i;
        }
        int j = last + 1;
        while (j < nbStep) {
            sb.append("   ");
            ++j;
        }
        return sb;
    }

    private CharSequence stringWithGhosts(int nbStep) {
        int nextGhost;
        StringBuilder sb = new StringBuilder();
        int current = 0;
        Iterator itTrace = this.trace.iterator();
        Iterator itGhost = this.ghosts.iterator();
        int nextTrace = itTrace.hasNext() ? (Integer)itTrace.next() : nbStep + 1;
        int n = nextGhost = itGhost.hasNext() ? (Integer)itGhost.next() : nbStep + 1;
        do {
            int next;
            String str;
            if (nextTrace < nextGhost) {
                str = "  x";
                next = nextTrace;
                nextTrace = itTrace.hasNext() ? (Integer)itTrace.next() : nbStep + 1;
            } else {
                str = "  -";
                next = nextGhost;
                nextGhost = itGhost.hasNext() ? (Integer)itGhost.next() : nbStep + 1;
            }
            while (current < next) {
                sb.append("   ");
                ++current;
            }
            sb.append(str);
        } while (++current <= nbStep);
        return sb;
    }

    public String toString() {
        return this.stringWithGhosts(this.lastCurrent).toString();
    }

    @Override
    public void ghost(int current) {
        this.ghosts.add(current);
        this.lastCurrent = current;
    }
}

