/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.common.graph;

import fr.kairos.common.graph.MyGraph;
import java.util.Stack;

public class StronglyConnectedComponents {
    private boolean[] marked;
    private int[] id;
    private int[] low;
    private int count;
    private Stack<Integer> stack;
    private int pre = 0;
    private MyGraph graph;

    public StronglyConnectedComponents(MyGraph graph) {
        this.marked = new boolean[graph.getNodeNumber()];
        this.stack = new Stack();
        this.id = new int[graph.getNodeNumber()];
        this.low = new int[graph.getNodeNumber()];
        this.graph = graph;
        int node = 0;
        while (node < graph.getNodeNumber()) {
            this.dfs(node);
            ++node;
        }
    }

    private void dfs(int current) {
        int w;
        if (this.marked[current]) {
            return;
        }
        this.marked[current] = true;
        int min = this.pre++;
        this.stack.push(current);
        for (int n : this.graph.neighbours(current)) {
            this.dfs(n);
            if (this.low[n] >= min) continue;
            min = this.low[n];
        }
        if (min < this.low[current]) {
            this.low[current] = min;
            return;
        }
        do {
            w = this.stack.pop();
            this.id[w] = this.count++;
            this.low[w] = this.graph.getNodeNumber();
        } while (w != current);
    }

    public int count() {
        return this.count;
    }

    public boolean stronglyConnected(int v, int w) {
        return this.id[v] == this.id[w];
    }
}

