/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.clocktree.ui;

import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.CoincidentClocks;
import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.Edge;
import grph.oo.ObjectGrph;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.eclipse.zest.core.viewers.ISelfStyleProvider;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;

public class ClockGraph4zest
implements IZoomableWorkbenchPart {
    private ObjectGrph<CoincidentClocks, Edge> _og = new ObjectGrph();
    private Graph _g;
    private GraphViewer _gv = null;

    public ClockGraph4zest(ObjectGrph<CoincidentClocks, Edge> g, Composite parent) {
        this(parent);
        this.setGrph(g);
    }

    public ClockGraph4zest(Composite parent) {
        this._gv = new GraphViewer(parent, 0);
        this._g = this._gv.getGraphControl();
        this._gv.setLabelProvider((IBaseLabelProvider)new LabellingProvider());
        this._gv.setContentProvider((IContentProvider)new GraphContentProvider());
        this._gv.addFilter((ViewerFilter)new ClockTreeFilter());
    }

    public void setGrph(ObjectGrph<CoincidentClocks, Edge> g) {
        this.dispose();
        this._og = g;
        this._gv.setInput(g);
    }

    public ObjectGrph<CoincidentClocks, Edge> getGrph() {
        return this._og;
    }

    public Graph getZestGraph() {
        return this._g;
    }

    public GraphViewer getZoomableViewer() {
        return this._gv;
    }

    public void dispose() {
        try {
            this._gv.setInput(new Object());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ClockTreeFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean cfr_ignored_0 = element instanceof Edge;
            boolean cfr_ignored_1 = element instanceof CoincidentClocks;
            return true;
        }
    }

    public static class GraphContentProvider
    implements IGraphContentProvider {
        private ObjectGrph<CoincidentClocks, Edge> _og = null;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this._og = null;
            if (newInput instanceof ObjectGrph) {
                this._og = (ObjectGrph)newInput;
            }
        }

        public Object getSource(Object rel) {
            if (rel instanceof Edge && this._og != null) {
                return this._og.getDirectedSimpleEdgeTail((Object)((Edge)rel));
            }
            if (rel instanceof CoincidentClocks) {
                return rel;
            }
            return null;
        }

        public Object getDestination(Object rel) {
            if (rel instanceof Edge && this._og != null) {
                return this._og.getDirectedSimpleEdgeHead((Object)((Edge)rel));
            }
            return null;
        }

        public Object[] getElements(Object input) {
            if (input instanceof ObjectGrph) {
                Collection tmp = this._og.getVertices();
                HashSet lst = new HashSet(tmp);
                lst.addAll(this._og.getEdges());
                return lst.toArray(new Object[lst.size()]);
            }
            return new Object[0];
        }
    }

    public static class LabellingProvider
    implements IBaseLabelProvider,
    ISelfStyleProvider {
        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void selfStyleConnection(Object element, GraphConnection c) {
            if (element instanceof Edge) {
                Edge e = (Edge)element;
                if (e.isConditional) {
                    c.setLineStyle(2);
                }
                Color color = e.getColor(null);
                c.setLineColor(color);
                c.setCurveDepth(0);
                c.setConnectionStyle(2);
                if (e.k_affineFunction != null) {
                    c.setText(String.valueOf(e.getLabel()) + "\n" + e.k_affineFunction);
                } else {
                    c.setText(e.getLabel());
                }
                c.setLineWidth(e.getSize());
            }
        }

        public void selfStyleNode(Object element, GraphNode node) {
            if (element instanceof CoincidentClocks) {
                CoincidentClocks v = (CoincidentClocks)element;
                node.setText(v.getVertexLabel());
                Color color = v.getEdgeColor(null);
                node.setBorderColor(color);
                Label fig = new Label(v.getLongVertexLabel());
                node.setTooltip((IFigure)fig);
            }
        }
    }
}

