/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class InitializeLayoutCommand
extends RecordingCommand {
    private final CreateRepresentationCommand command;
    private final IGraphicalEditPart editPart;
    private DRepresentation layoutedRepresentation;

    public InitializeLayoutCommand(TransactionalEditingDomain domain, CreateRepresentationCommand command, IGraphicalEditPart editPart) {
        super(domain, Messages.InitializeLayoutCommand_label);
        this.command = command;
        this.editPart = editPart;
    }

    protected void doExecute() {
        this.layoutedRepresentation = this.command.getCreatedRepresentation();
        if (this.layoutedRepresentation != null && this.editPart != null) {
            LayoutUtils.initializeDiagramLayout(this.editPart.getNotationView().getDiagram(), this.layoutedRepresentation);
        }
    }

    public Collection<?> getResult() {
        return new ArrayList<DRepresentation>(Arrays.asList(this.layoutedRepresentation));
    }

    public DRepresentation getLayoutedRepresentation() {
        return this.layoutedRepresentation;
    }
}

