/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.actions.OpenPomAction;
import org.eclipse.m2e.core.ui.internal.dialogs.InputHistory;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.internal.FormHoverProvider;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.ElementValueProvider;
import org.eclipse.m2e.editor.pom.FormUtils;
import org.eclipse.m2e.editor.pom.MavenPomEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MavenPomEditorPage
extends FormPage {
    private static final String MODIFY_LISTENER = "MODIFY_LISTENER";
    private static final String VALUE_PROVIDER = "VALUE_PROVIDER";
    private static final Logger LOG = LoggerFactory.getLogger(MavenPomEditorPage.class);
    protected final MavenPomEditor pomEditor;
    private boolean updatingModel2 = false;
    private boolean dataLoaded;
    private final InputHistory inputHistory;
    private Action selectParentAction;
    private final IModelStateListener listener;
    private boolean alreadyShown = false;

    public MavenPomEditorPage(MavenPomEditor pomEditor, String id, String title) {
        super((FormEditor)pomEditor, id, title);
        this.pomEditor = pomEditor;
        this.inputHistory = new InputHistory(id);
        this.listener = new IModelStateListener(){

            public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
            }

            public void modelResourceDeleted(IStructuredModel model) {
            }

            public void modelReinitialized(IStructuredModel structuredModel) {
            }

            public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
            }

            public void modelChanged(IStructuredModel model) {
                if (!MavenPomEditorPage.this.updatingModel2) {
                    MavenPomEditorPage.this.loadData();
                }
            }

            public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
            }

            public void modelAboutToBeChanged(IStructuredModel model) {
            }
        };
    }

    public MavenPomEditor getPomEditor() {
        return this.pomEditor;
    }

    public final void performEditOperation(PomEdits.Operation operation, Logger logger, String logMessage) {
        try {
            try {
                this.updatingModel2 = true;
                PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.getPomEditor().getDocument(), operation)});
            }
            catch (Exception e) {
                logger.error(logMessage, (Throwable)e);
                this.updatingModel2 = false;
            }
        }
        finally {
            this.updatingModel2 = false;
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        IToolBarManager toolBarManager = form.getToolBarManager();
        this.selectParentAction = new Action(Messages.MavenPomEditorPage_action_open, MavenEditorImages.PARENT_POM){

            public void run() {
                final String[] ret = new String[3];
                try {
                    PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(MavenPomEditorPage.this.getPomEditor().getDocument(), document -> {
                        Element parent = PomEdits.findChild((Element)document.getDocumentElement(), (String)"parent");
                        stringArray[0] = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"groupId"));
                        stringArray[1] = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"artifactId"));
                        stringArray[2] = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"version"));
                    }, true)});
                    if (!(FormUtils.isEmpty(ret[0]) || FormUtils.isEmpty(ret[1]) || FormUtils.isEmpty(ret[2]))) {
                        new Job(Messages.MavenPomEditorPage_job_opening){

                            protected IStatus run(IProgressMonitor monitor) {
                                OpenPomAction.openEditor((String)ret[0], (String)ret[1], (String)ret[2], (MavenProject)MavenPomEditorPage.this.getPomEditor().getMavenProject(), (IProgressMonitor)monitor);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                }
                catch (Exception e) {
                    LOG.error("Error finding parent element", (Throwable)e);
                }
            }
        };
        toolBarManager.add((IAction)this.selectParentAction);
        this.updateParentAction();
        toolBarManager.add((IAction)new Action(Messages.MavenPomEditorPage_actio_refresh, MavenEditorImages.REFRESH){

            public void run() {
                MavenPomEditorPage.this.pomEditor.reload();
            }
        });
        form.updateToolBar();
        FormUtils.decorateHeader(managedForm.getToolkit(), form.getForm());
        this.inputHistory.load();
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.doLoadData(active);
        if (active) {
            this.getPomEditor().getModel().addModelStateListener(this.listener);
        } else {
            this.getPomEditor().getModel().removeModelStateListener(this.listener);
        }
        if (active && this.alreadyShown) {
            this.loadData();
            this.updateParentAction();
        }
        this.alreadyShown = true;
        boolean readOnly = this.pomEditor.checkReadOnly();
        if (readOnly) {
            FormUtils.setReadonly((Composite)this.getPartControl(), readOnly);
        }
    }

    public boolean isReadOnly() {
        return this.pomEditor.checkReadOnly();
    }

    private void doLoadData(boolean active) {
        try {
            IFile pomFile;
            if (active && !this.dataLoaded) {
                this.dataLoaded = true;
                if (this.getPartControl() != null) {
                    this.getPartControl().getDisplay().asyncExec(() -> {
                        try {
                            this.loadData();
                            this.updateParentAction();
                        }
                        catch (Throwable e) {
                            LOG.error("Error loading data", e);
                        }
                    });
                }
            }
            if ((pomFile = this.pomEditor.getPomFile()) != null) {
                String text = "";
                IMarker[] markers = pomFile.findMarkers("org.eclipse.m2e.core.maven2Problem", true, 0);
                IMarker max = null;
                int maxSev = -1;
                if (markers != null) {
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker mark = iMarkerArray[n2];
                        IMarker toAdd = max;
                        int sev = mark.getAttribute("severity", -1);
                        if (sev > maxSev) {
                            max = mark;
                            maxSev = sev;
                        } else {
                            toAdd = mark;
                        }
                        if (toAdd != null) {
                            text = toAdd.getAttribute("severity", -1) == 2 ? String.valueOf(NLS.bind((String)Messages.MavenPomEditorPage_error_add, (Object)toAdd.getAttribute("message", ""))) + text : String.valueOf(text) + NLS.bind((String)Messages.MavenPomEditorPage_warning_add, (Object)toAdd.getAttribute("message", ""));
                        }
                        ++n2;
                    }
                }
                if (max != null) {
                    int severity;
                    String head;
                    String maxText = max.getAttribute("message", Messages.MavenPomEditorPage_error_unknown);
                    if (text.length() > 0) {
                        text = NLS.bind((String)Messages.MavenPomEditorPage_add_desc, (Object)maxText, (Object)text);
                        if (markers != null) {
                            String number = Integer.toString(markers.length - 1);
                            head = NLS.bind((String)Messages.FormUtils_click_for_details2, (Object)(maxText.length() > 80 ? maxText.substring(0, 80) : maxText), (Object)number);
                        } else {
                            head = maxText;
                            if (head.length() > 80) {
                                head = NLS.bind((String)Messages.FormUtils_click_for_details, (Object)head.substring(0, 80));
                            }
                        }
                    } else {
                        text = maxText;
                        head = maxText;
                        if (head.length() > 80) {
                            head = NLS.bind((String)Messages.FormUtils_click_for_details, (Object)head.substring(0, 80));
                        }
                    }
                    switch (max.getAttribute("severity", -1)) {
                        case 2: {
                            severity = 3;
                            break;
                        }
                        case 1: {
                            severity = 2;
                            break;
                        }
                        case 0: {
                            severity = 1;
                            break;
                        }
                        default: {
                            severity = 0;
                        }
                    }
                    this.setErrorMessageForMarkers(head, text, severity, markers);
                } else {
                    this.setErrorMessageForMarkers(null, null, 0, new IMarker[0]);
                }
            }
        }
        catch (CoreException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            String msg = ex.getMessage();
            this.setErrorMessageForMarkers(msg, msg, 3, new IMarker[0]);
        }
    }

    private void setErrorMessageForMarkers(String msg, String tip, int severity, IMarker[] markers) {
        if (this.getPartControl() != null && !this.getPartControl().isDisposed()) {
            this.getPartControl().getDisplay().asyncExec(() -> {
                if (!this.getManagedForm().getForm().isDisposed()) {
                    ISourceViewer sourceViewer = null;
                    try {
                        Method getSourceViewer = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
                        getSourceViewer.setAccessible(true);
                        sourceViewer = (ISourceViewer)getSourceViewer.invoke((Object)this.getPomEditor().getSourcePage(), new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                    Consumer<Point> runnable = FormHoverProvider.createHoverRunnable(this.getManagedForm().getForm().getShell(), markers, sourceViewer);
                    if (runnable != null) {
                        FormUtils.setMessageWithPerformer(this.getManagedForm().getForm(), msg, severity, runnable);
                    } else {
                        FormUtils.setMessageAndTTip(this.getManagedForm().getForm(), msg, tip, severity);
                    }
                }
            });
        }
    }

    public void setErrorMessage(String msg, int severity) {
        if (this.getPartControl() != null && !this.getPartControl().isDisposed()) {
            this.getPartControl().getDisplay().asyncExec(() -> {
                if (!this.getManagedForm().getForm().isDisposed()) {
                    FormUtils.setMessage(this.getManagedForm().getForm(), msg, severity);
                }
            });
        }
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    private void updateParentAction() {
        if (this.selectParentAction != null) {
            boolean[] ret = new boolean[1];
            try {
                PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.getPomEditor().getDocument(), document -> {
                    Element parent = PomEdits.findChild((Element)document.getDocumentElement(), (String)"parent");
                    String g = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"groupId"));
                    String a = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"artifactId"));
                    String v = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"version"));
                    blArray[0] = g != null && a != null && v != null;
                }, true)});
            }
            catch (Exception e) {
                ret[0] = false;
            }
            this.selectParentAction.setEnabled(ret[0]);
        }
    }

    public final void createEvaluatorInfo(final Control control) {
        if (!(control instanceof Text) && !(control instanceof CCombo)) {
            throw new IllegalArgumentException("Not a Text or CCombo");
        }
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        final ControlDecoration decoration = new ControlDecoration(control, 131200){

            public String getDescriptionText() {
                MavenProject mp = MavenPomEditorPage.this.getPomEditor().getMavenProject();
                if (mp != null) {
                    return FormUtils.simpleInterpolate(mp, control instanceof Text ? ((Text)control).getText() : ((CCombo)control).getText());
                }
                return "Cannot interpolate expressions, not resolvable file.";
            }
        };
        decoration.setShowOnlyOnFocus(false);
        decoration.setImage(fieldDecoration.getImage());
        decoration.setShowHover(true);
        decoration.hide();
        decoration.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> decoration.showHoverText(decoration.getDescriptionText())));
        ModifyListener listener = e -> {
            String text;
            String string = text = control instanceof Text ? ((Text)control).getText() : ((CCombo)control).getText();
            if (text.indexOf("${") != -1 && text.indexOf("}") != -1) {
                decoration.show();
            } else {
                decoration.hide();
            }
        };
        if (control instanceof Text) {
            ((Text)control).addModifyListener(listener);
        } else {
            ((CCombo)control).addModifyListener(listener);
        }
        control.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                decoration.showHoverText(decoration.getDescriptionText());
            }

            public void mouseExit(MouseEvent e) {
                decoration.hideHover();
            }

            public void mouseEnter(MouseEvent e) {
            }
        });
    }

    public void dispose() {
        this.inputHistory.save();
        MavenPomEditor pe = this.getPomEditor();
        if (pe != null && pe.getModel() != null) {
            pe.getModel().removeModelStateListener(this.listener);
        }
        super.dispose();
    }

    public abstract void loadData();

    public void setElementValueProvider(Control control, ElementValueProvider provider) {
        control.setData(VALUE_PROVIDER, (Object)provider);
    }

    public void setModifyListener(final Control control) {
        Assert.isTrue((control instanceof CCombo || control instanceof Text || control instanceof Combo ? 1 : 0) != 0);
        ModifyListener ml = new ModifyListener(){

            String getText(Control control2) {
                if (control2 instanceof Text) {
                    return ((Text)control2).getText();
                }
                if (control2 instanceof Combo) {
                    return ((Combo)control2).getText();
                }
                if (control2 instanceof CCombo) {
                    return ((CCombo)control2).getText();
                }
                throw new IllegalStateException();
            }

            public void modifyText(ModifyEvent e) {
                ElementValueProvider provider = (ElementValueProvider)control.getData(MavenPomEditorPage.VALUE_PROVIDER);
                if (provider == null) {
                    throw new IllegalStateException("no value provider for " + control);
                }
                MavenPomEditorPage.this.performEditOperation(document -> {
                    String text = this.getText(control);
                    if (FormUtils.isEmpty(text) || text.equals(provider.getDefaultValue())) {
                        Node parent;
                        Element el1 = provider.find(document);
                        if (el1 != null && (parent = el1.getParentNode()) instanceof Element) {
                            PomEdits.removeChild((Element)((Element)parent), (Element)el1);
                            PomEdits.removeIfNoChildElement((Element)((Element)parent));
                        }
                    } else {
                        Element el2 = provider.get(document);
                        PomEdits.setText((Element)el2, (String)text);
                    }
                }, LOG, "Error updating document");
            }
        };
        control.setData(MODIFY_LISTENER, (Object)ml);
    }

    public void removeNotifyListener(Text control) {
        ModifyListener listener;
        if (!control.isDisposed() && (listener = (ModifyListener)control.getData(MODIFY_LISTENER)) != null) {
            control.removeModifyListener(listener);
        }
    }

    public void addNotifyListener(Text control) {
        ModifyListener listener;
        if (!control.isDisposed() && (listener = (ModifyListener)control.getData(MODIFY_LISTENER)) != null) {
            control.addModifyListener(listener);
        }
    }

    public void removeNotifyListener(CCombo control) {
        ModifyListener listener;
        if (!control.isDisposed() && (listener = (ModifyListener)control.getData(MODIFY_LISTENER)) != null) {
            control.removeModifyListener(listener);
        }
    }

    public void addNotifyListener(CCombo control) {
        ModifyListener listener;
        if (!control.isDisposed() && (listener = (ModifyListener)control.getData(MODIFY_LISTENER)) != null) {
            control.addModifyListener(listener);
        }
    }

    public void removeNotifyListener(Combo control) {
        ModifyListener listener;
        if (!control.isDisposed() && (listener = (ModifyListener)control.getData(MODIFY_LISTENER)) != null) {
            control.removeModifyListener(listener);
        }
    }

    public void addNotifyListener(Combo control) {
        ModifyListener listener;
        if (!control.isDisposed() && (listener = (ModifyListener)control.getData(MODIFY_LISTENER)) != null) {
            control.addModifyListener(listener);
        }
    }

    public IMavenProjectFacade findModuleProject(String moduleName) {
        IFile pomFile = this.pomEditor.getPomFile();
        if (pomFile != null) {
            return this.findModuleProject(pomFile, moduleName);
        }
        return null;
    }

    private IMavenProjectFacade findModuleProject(IFile pomFile, String module) {
        IMavenProjectFacade[] facades;
        IPath modulePath = pomFile.getParent().getLocation();
        if (modulePath == null) {
            return null;
        }
        if (!(modulePath = modulePath.append(module)).lastSegment().endsWith("pom.xml")) {
            modulePath = modulePath.append("pom.xml");
        }
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade[] iMavenProjectFacadeArray = facades = projectManager.getProjects();
        int n = facades.length;
        int n2 = 0;
        while (n2 < n) {
            IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
            if (modulePath.equals((Object)facade.getPom().getLocation())) {
                return facade;
            }
            ++n2;
        }
        return null;
    }

    public IFile findModuleFile(String moduleName) {
        IFile pomFile = this.pomEditor.getPomFile();
        if (pomFile != null) {
            IPath modulePath = pomFile.getParent().getLocation();
            if (modulePath == null) {
                return null;
            }
            if (!(modulePath = modulePath.append(moduleName)).lastSegment().endsWith("pom.xml")) {
                modulePath = modulePath.append("pom.xml");
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(modulePath);
            return file;
        }
        return null;
    }

    public void initPopupMenu(Viewer viewer, String id) {
        MenuManager menuMgr = new MenuManager("#PopupMenu-" + id);
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getEditorSite().registerContextMenu("org.eclipse.m2e.editor.MavenPomEditor" + id, menuMgr, (ISelectionProvider)viewer, false);
    }

    public IProject getProject() {
        IFile pomFile = this.pomEditor.getPomFile();
        return pomFile != null ? pomFile.getProject() : null;
    }

    protected void addToHistory(Control control) {
        this.inputHistory.add(control);
    }

    public void mavenProjectHasChanged() {
    }

    public static interface TextAdapter {
        public String getText();

        public void addModifyListener(ModifyListener var1);
    }
}

