/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders;

import java.util.List;
import java.util.concurrent.Semaphore;
import org.eclipse.gemoc.commons.eclipse.ui.ViewHelper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.SharedIcons;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.step.LogicalStepsView;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.AbstractConcurrentExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.ILogicalStepDecider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.DeciderException;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;

public abstract class AbstractUserDecider
implements ILogicalStepDecider {
    private Step _selectedLogicalStep;
    private Semaphore _semaphore = null;
    private LogicalStepsView decisionView;
    private boolean _preemptionHappened = false;

    public Step decide(final AbstractConcurrentExecutionEngine engine, List<Step<?>> possibleLogicalSteps) throws DeciderException {
        this._preemptionHappened = false;
        this._semaphore = new Semaphore(0);
        if (!this.isStepByStep() && engine.getPossibleLogicalSteps().size() == 1) {
            return possibleLogicalSteps.get(0);
        }
        this.decisionView = (LogicalStepsView)((Object)ViewHelper.retrieveView((String)"org.eclipse.gemoc.executionframework.engine.io.views.steps.LogicalStepsView"));
        this.decisionView.refresh();
        IMenuListener2 menuListener = new IMenuListener2(){
            private Action _action = null;

            public void menuAboutToShow(IMenuManager manager) {
                if (this._action == null && AbstractUserDecider.this.decisionView.getSelectedLogicalStep() != null && engine.getPossibleLogicalSteps().contains(AbstractUserDecider.this.decisionView.getSelectedLogicalStep())) {
                    this._action = AbstractUserDecider.this.createAction();
                }
                if (AbstractUserDecider.this.decisionView.getSelectedLogicalStep() != null && this._action != null) {
                    manager.add((IAction)this._action);
                }
            }

            public void menuAboutToHide(IMenuManager manager) {
                if (this._action != null) {
                    manager.remove(this._action.getId());
                }
            }
        };
        this.decisionView.addMenuListener(menuListener);
        IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (AbstractUserDecider.this.decisionView.getSelectedLogicalStep() != null && engine.getPossibleLogicalSteps().contains(AbstractUserDecider.this.decisionView.getSelectedLogicalStep())) {
                    Action selectLogicalStepAction = new Action(){

                        public void run() {
                            AbstractUserDecider.this._selectedLogicalStep = AbstractUserDecider.this.decisionView.getSelectedLogicalStep();
                            AbstractUserDecider.this._semaphore.release();
                        }
                    };
                    selectLogicalStepAction.run();
                }
            }
        };
        this.decisionView.addDoubleClickListener(doubleClickListener);
        try {
            this._semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new DeciderException((Throwable)e);
        }
        this._semaphore = null;
        this.decisionView.removeMenuListener(menuListener);
        this.decisionView.removeDoubleClickListener(doubleClickListener);
        if (this._preemptionHappened) {
            return null;
        }
        return this._selectedLogicalStep;
    }

    public void dispose() {
        if (this._semaphore != null) {
            this._semaphore.release();
        }
        this.decisionView.refresh();
    }

    public void preempt() {
        this._preemptionHappened = true;
        if (this._semaphore != null) {
            this._semaphore.release();
        }
    }

    private Action createAction() {
        Action selectLogicalStepAction = new Action(){

            public void run() {
                AbstractUserDecider.this._selectedLogicalStep = AbstractUserDecider.this.decisionView.getSelectedLogicalStep();
                AbstractUserDecider.this._semaphore.release();
            }
        };
        selectLogicalStepAction.setId("org.eclipse.gemoc.executionframework.engine.io.commands.SelectLogicalStep");
        selectLogicalStepAction.setText("Select LogicalStep");
        selectLogicalStepAction.setToolTipText("Use selected LogicalStep");
        selectLogicalStepAction.setImageDescriptor(SharedIcons.LOGICALSTEP_ICON);
        return selectLogicalStepAction;
    }

    public abstract boolean isStepByStep();

    public void decideFromTimeLine(Step logicalStep) {
        this._selectedLogicalStep = logicalStep;
        if (this._semaphore != null) {
            this._semaphore.release();
        }
    }
}

