/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.actions.GenerateExtendedCCSLFileAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.MoccmlLanguageAdditionExtension;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.MoccmlLanguageAdditionExtensionPoint;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtensionPoint;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class GenerateExtendedCCSLFile
extends GenerateExtendedCCSLFileAction {
    @Override
    protected String getTransformationURI() {
        String fileExtension = this.modelUriString.substring(this.modelUriString.lastIndexOf(46) + 1, this.modelUriString.length());
        List applicableLanguageDefinitions = LanguageDefinitionExtensionPoint.getSpecifications().stream().filter(lde -> lde.getFileExtensions().contains(fileExtension)).filter(lde -> MoccmlLanguageAdditionExtensionPoint.findMoccmlLanguageAdditionForLanguage((String)lde.getName()) != null).collect(Collectors.toList());
        LanguageDefinitionExtension selectedLanguageDefinition = null;
        if (applicableLanguageDefinitions.size() == 0) {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "No applicable language found", null, "No applicable language found for file extension " + fileExtension + ".", 1, new String[0], -1);
            dialog.open();
            return null;
        }
        if (applicableLanguageDefinitions.size() == 1) {
            selectedLanguageDefinition = (LanguageDefinitionExtension)applicableLanguageDefinitions.get(0);
        } else {
            ListDialog dialog = new ListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setTitle("Language selection");
            dialog.setMessage("Which language do you want to use");
            dialog.setLabelProvider((ILabelProvider)new ArrayLabelProvider());
            ArrayList<Object[]> input = new ArrayList<Object[]>();
            for (LanguageDefinitionExtension lde2 : applicableLanguageDefinitions) {
                input.add(new Object[]{lde2.getName(), lde2});
            }
            dialog.setInput(input);
            if (dialog.open() != 0) {
                return null;
            }
            Object[] result = dialog.getResult();
            if (result.length == 0) {
                MessageDialog dialog2 = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Please select a language", null, "Please select a language for file extension " + fileExtension + ".", 1, new String[0], -1);
                dialog2.open();
                return null;
            }
            Object[] selected = (Object[])result[0];
            selectedLanguageDefinition = (LanguageDefinitionExtension)selected[1];
        }
        MoccmlLanguageAdditionExtension moccmlAddition = MoccmlLanguageAdditionExtensionPoint.findMoccmlLanguageAdditionForLanguage((String)selectedLanguageDefinition.getName());
        String uri = moccmlAddition.getQVTOPath();
        if (!uri.startsWith("platform:/plugin")) {
            uri = "platform:/plugin" + uri;
        }
        return uri;
    }

    @Override
    protected String getMoCFileExtension() {
        return "extendedCCSL";
    }

    static class ArrayLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArrayLabelProvider() {
        }

        public String getText(Object element) {
            return ((Object[])element)[0].toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object[] ss = (Object[])element;
            return ss[columnIndex].toString();
        }
    }
}

