/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.mtl.ide;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.parser.interpreter.ModuleDescriptor;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.sirius.common.acceleo.mtl.business.api.ResourceFinder;
import org.eclipse.sirius.common.acceleo.mtl.business.api.extension.AbstractImportHandler;
import org.eclipse.sirius.common.acceleo.mtl.business.api.extension.DynamicJavaModuleCreator;

public class WorkspaceJavaImportHandler
extends AbstractImportHandler {
    private static List<IMethod> getPublicMethods(ICompilationUnit compilationUnit) throws JavaModelException {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IType[] types = compilationUnit.getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].getElementType() == 7) {
                IJavaElement[] iJavaElementArray = types[i].getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    if (child instanceof IMethod && Flags.isPublic((int)((IMethod)child).getFlags())) {
                        methods.add((IMethod)child);
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return methods;
    }

    private static List<String> getPublicSignaturesFrom(IFile javaFile) {
        ArrayList<String> signatures = new ArrayList<String>();
        IJavaElement javaElement = JavaCore.create((IFile)javaFile);
        if (javaElement instanceof ICompilationUnit) {
            ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
            try {
                List<IMethod> publicMethods = WorkspaceJavaImportHandler.getPublicMethods(compilationUnit);
                for (IMethod method : publicMethods) {
                    IType context = (IType)method.getParent();
                    StringBuilder signature = new StringBuilder();
                    signature.append(WorkspaceJavaImportHandler.resolveType(context, method.getReturnType())).append(' ');
                    signature.append(method.getElementName()).append('(');
                    String[] params = method.getParameterTypes();
                    int i = 0;
                    while (i < params.length) {
                        signature.append(WorkspaceJavaImportHandler.resolveType(context, params[i]));
                        if (i < params.length - 1) {
                            signature.append(',');
                        }
                        ++i;
                    }
                    signature.append(')');
                    signatures.add(signature.toString());
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return signatures;
    }

    private static boolean isJavaFile(IFile file) {
        return JavaCore.create((IFile)file) instanceof ICompilationUnit;
    }

    private static String resolveType(IType context, String typeSignature) {
        String typeErasure = Signature.toString((String)Signature.getTypeErasure((String)typeSignature));
        String[] args = Signature.getTypeArguments((String)typeSignature);
        String[] typeArguments = new String[args.length];
        int i = 0;
        while (i < args.length) {
            typeArguments[i] = Signature.toString((String)args[i]);
            ++i;
        }
        StringBuilder resolved = new StringBuilder();
        resolved.append(WorkspaceJavaImportHandler.resolveSourceType(context, typeErasure));
        if (typeArguments.length > 0) {
            resolved.append('<');
            int i2 = 0;
            while (i2 < typeArguments.length) {
                if (i2 > 0) {
                    resolved.append(',');
                }
                resolved.append(WorkspaceJavaImportHandler.resolveSourceType(context, typeArguments[i2]));
                ++i2;
            }
            resolved.append('>');
        }
        return resolved.toString();
    }

    private static String resolveSourceType(IType context, String sourceType) {
        try {
            String[][] erasure = sourceType.contains("? extends ") ? context.resolveType(sourceType.substring(sourceType.indexOf("? extends ") + "? extends ".length())) : context.resolveType(sourceType);
            String resolved = null;
            if (erasure != null && erasure.length > 0) {
                Object[] parts = erasure[0];
                resolved = Joiner.on((char)'.').join(parts);
            } else {
                IImportDeclaration[] imports = context.getCompilationUnit().getImports();
                int i = 0;
                while (i < imports.length && resolved == null) {
                    String importName;
                    IImportDeclaration importDeclaration = imports[i];
                    if (!importDeclaration.isOnDemand() && (importName = importDeclaration.getElementName()).endsWith(sourceType)) {
                        resolved = importName;
                    }
                    ++i;
                }
            }
            return resolved;
        }
        catch (JavaModelException javaModelException) {
            return sourceType;
        }
    }

    public boolean canImport(Set<String> viewpointPlugins, Set<String> viewpointProjects, String dependency) {
        return this.candidateExist(dependency);
    }

    public ModuleDescriptor createImport(Set<String> viewpointPlugins, Set<String> viewpointProjects, String dependency) {
        List<IFile> javaCandidates = this.findJavaCandidates(dependency);
        WorkspaceJavaModuleDescriptor module = null;
        if (!javaCandidates.isEmpty()) {
            IFile javaFile = javaCandidates.get(0);
            URI moduleURI = this.getPlatformResourceURI(javaFile);
            module = new WorkspaceJavaModuleDescriptor(moduleURI, dependency.replace(".", "::"), javaFile);
        }
        return module;
    }

    private URI getPlatformResourceURI(IFile file) {
        return URI.createURI((String)("platform:/resource" + file.getFullPath().removeFileExtension().addFileExtension("emtl")));
    }

    private boolean candidateExist(String qualifiedName) {
        String javaPath = qualifiedName.replace('.', '/');
        javaPath = String.valueOf(javaPath) + ".java";
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Iterable accessibleProjects = Iterables.filter(Arrays.asList(projects), (Predicate)new AccessibleProjectPredicate());
        for (IProject project : accessibleProjects) {
            try {
                ResourceFinder javaFinder = new ResourceFinder(javaPath){

                    public boolean visit(IResource resource) throws CoreException {
                        if (this.path.length == 0 || this.getMatches().size() != 0) {
                            return false;
                        }
                        if (this.isCandidate(resource) && resource instanceof IFile && WorkspaceJavaImportHandler.isJavaFile((IFile)resource)) {
                            this.getMatches().add(resource);
                        }
                        return this.getMatches().size() == 0;
                    }
                };
                project.accept((IResourceVisitor)javaFinder);
                if (javaFinder.getMatches().size() == 0) continue;
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private List<IFile> findJavaCandidates(String qualifiedName) {
        ArrayList<IFile> candidates = new ArrayList<IFile>();
        String javaPath = qualifiedName.replace('.', '/');
        javaPath = String.valueOf(javaPath) + ".java";
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Iterable accessibleProjects = Iterables.filter(Arrays.asList(projects), (Predicate)new AccessibleProjectPredicate());
        for (IProject project : accessibleProjects) {
            try {
                ResourceFinder javaFinder = new ResourceFinder(javaPath);
                project.accept((IResourceVisitor)javaFinder);
                Iterables.addAll(candidates, (Iterable)Iterables.filter((Iterable)javaFinder.getMatches(), IFile.class));
            }
            catch (CoreException coreException) {}
        }
        return candidates;
    }

    private static final class AccessibleProjectPredicate
    implements Predicate<IProject> {
        private AccessibleProjectPredicate() {
        }

        public boolean apply(IProject input) {
            return input.isAccessible() && input.isOpen() && !input.isDerived();
        }
    }

    private static final class WorkspaceJavaModuleDescriptor
    extends ModuleDescriptor {
        private final IFile javaFile;
        private long lastTimeStamp;
        private String moduleContent;

        WorkspaceJavaModuleDescriptor(URI moduleURI, String qualifiedName, IFile javaFile) {
            super(moduleURI, qualifiedName, "");
            this.javaFile = javaFile;
        }

        public String getModuleContent() {
            long modificationStamp = this.getModificationStamp((IResource)this.javaFile);
            if (this.lastTimeStamp == -1L || this.lastTimeStamp == modificationStamp) {
                return this.moduleContent;
            }
            List<String> publicSignatures = WorkspaceJavaImportHandler.getPublicSignaturesFrom(this.javaFile);
            String javaQualifiedName = this.getQualifiedName().replace("::", ".");
            this.moduleContent = DynamicJavaModuleCreator.createModule((String)javaQualifiedName, publicSignatures);
            this.lastTimeStamp = modificationStamp;
            return this.moduleContent;
        }

        private long getModificationStamp(IResource resource) {
            ITextFileBuffer buffer;
            if (resource instanceof IFile && (buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE)) != null && buffer.getDocument() instanceof IDocumentExtension4) {
                long stamp = ((IDocumentExtension4)buffer.getDocument()).getModificationStamp();
                if (stamp == -1L) {
                    stamp = -1L;
                }
                return stamp;
            }
            return resource.getModificationStamp();
        }
    }
}

