/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.query;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.internal.session.parser.RepresentationsFileSaxParser;
import org.eclipse.sirius.common.tools.api.util.WorkspaceUtil;
import org.eclipse.sirius.tools.api.Messages;

public class ModelingProjectQuery {
    public static final String ZERO_REPRESENTATIONS_FILE_FOUND_IN = "0";
    public static final String A_MODELING_PROJECT_MUST_CONTAIN_ONLY_ONE = "*";
    private final ModelingProject modelingProject;

    public ModelingProjectQuery(ModelingProject modelingProject) {
        this.modelingProject = modelingProject;
    }

    public List<IFile> getRepresentationFiles() {
        return WorkspaceUtil.getFilesFromWorkspace(Collections.singleton(this.modelingProject.getProject()), (String)"aird");
    }

    public URI computeMainRepresentationsFileURI(IProgressMonitor monitor) throws IllegalArgumentException {
        URI result = null;
        List<IFile> sessionFiles = this.getRepresentationFiles();
        monitor.beginTask("", sessionFiles.size() + 1);
        HashMap<URI, Set<URI>> references = new HashMap<URI, Set<URI>>(sessionFiles.size());
        for (IFile sessionFile : sessionFiles) {
            RepresentationsFileSaxParser sessionSaxParser = new RepresentationsFileSaxParser(sessionFile);
            sessionSaxParser.analyze((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            references.put(sessionSaxParser.getRepresentationsFileURI(), sessionSaxParser.getReferencedAnalysis());
        }
        ArrayList<URI> notReferencedURIs = new ArrayList<URI>();
        ArrayList keys = new ArrayList(references.keySet());
        for (URI uri : references.keySet()) {
            boolean referenced = false;
            for (URI uri2 : keys) {
                if (!((Set)references.get(uri2)).contains(uri)) continue;
                referenced = true;
                break;
            }
            if (referenced) continue;
            notReferencedURIs.add(uri);
        }
        monitor.worked(1);
        if (notReferencedURIs.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ModelingProjectQuery_mustContainOneRepFileMsg, this.modelingProject.getProject().getName()), new Throwable(ZERO_REPRESENTATIONS_FILE_FOUND_IN));
        }
        if (notReferencedURIs.size() != 1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ModelingProjectQuery_severalRepresentationsFiles, notReferencedURIs.size(), this.modelingProject.getProject().getName(), this.getFragments(notReferencedURIs)), new Throwable(A_MODELING_PROJECT_MUST_CONTAIN_ONLY_ONE));
        }
        result = (URI)notReferencedURIs.get(0);
        monitor.done();
        return result;
    }

    private String getFragments(List<URI> uris) {
        StringBuffer result = new StringBuffer();
        Iterator<URI> iterator = uris.iterator();
        while (iterator.hasNext()) {
            URI uri = iterator.next();
            if (!iterator.hasNext()) {
                result.delete(result.length() - 2, result.length());
                result.append(Messages.ModelingProjectQuery_and);
            }
            result.append(uri.lastSegment());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

