/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.modelunfolding;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.DenseClockType;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Type;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.Block;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.ClassicalExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.KernelExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.KernelRelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.AbstractConcreteMapping;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationPath;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InstantiatedElement {
    private static long elementCount = 0L;
    public static final String defaultSeparator = "::";
    private InstantiationPath instantiationPath;
    private AbstractConcreteMapping<InstantiatedElement> abstractMapping;
    private long id;
    private boolean leaf;
    private NamedElement definition;
    private boolean isKernel;
    private boolean assertion;
    private boolean conditional;
    private boolean conditionCase;
    private boolean recursiveCall;
    private boolean tailRecursiveCall;
    private InstantiatedElement rootExpression;
    private List<InstantiatedElement> subCases;
    private InstantiatedElement defaultCase;
    private InstantiatedElement conditionTest;
    private InstantiatedElement parent;
    private List<InstantiatedElement> sons;
    private boolean topLevel;
    private long useCount;
    private boolean constant;
    private Element value;

    private static synchronized long nextCount() {
        return ++elementCount;
    }

    public InstantiatedElement(InstantiationPath path, AbstractConcreteMapping<InstantiatedElement> acm) {
        this.instantiationPath = path;
        this.abstractMapping = acm;
        this.id = InstantiatedElement.nextCount();
        this.leaf = false;
        this.definition = null;
        this.conditional = false;
        this.conditionCase = false;
        this.recursiveCall = false;
        this.tailRecursiveCall = false;
        this.topLevel = false;
        this.useCount = 0L;
        this.setRootExpression(null);
        this.defaultCase = null;
        this.conditionTest = null;
        this.parent = null;
    }

    public InstantiationPath getInstantiationPath() {
        return this.instantiationPath;
    }

    public AbstractConcreteMapping<InstantiatedElement> getAbstractMapping() {
        return this.abstractMapping;
    }

    public void setAbstractMapping(AbstractConcreteMapping<InstantiatedElement> abstractMapping) {
        this.abstractMapping = abstractMapping;
    }

    public String getQualifiedName(String separator) {
        String res = "";
        Iterator it = this.instantiationPath.iterator();
        while (it.hasNext()) {
            String name = ((NamedElement)it.next()).getName();
            res = name.isEmpty() ? String.valueOf(res) + "<NoName>" : String.valueOf(res) + name;
            if (!it.hasNext()) continue;
            res = String.valueOf(res) + separator;
        }
        return res;
    }

    public String getQualifiedName() {
        return this.getQualifiedName(defaultSeparator);
    }

    public NamedElement getDeclaration() {
        NamedElement last = this.instantiationPath.getLast();
        if (last == null) {
            return null;
        }
        if (last instanceof Relation) {
            return ((Relation)last).getType();
        }
        if (last instanceof Expression) {
            return ((Expression)last).getType();
        }
        return null;
    }

    public NamedElement getDefinition() {
        return this.definition;
    }

    public void setDefinition(NamedElement def) {
        this.definition = def;
    }

    public boolean isExpression() {
        NamedElement last = this.instantiationPath.getLast();
        return last != null && last instanceof Expression;
    }

    public InstantiatedElement getRootExpression() {
        return this.rootExpression;
    }

    public void setRootExpression(InstantiatedElement rootExpression) {
        this.rootExpression = rootExpression;
    }

    public boolean isKernelExpression() {
        return this.isExpression() && this.isKernel;
    }

    public boolean isRelation() {
        NamedElement last = this.instantiationPath.getLast();
        return last != null && last instanceof Relation;
    }

    public void setAssertion(boolean assertion) {
        this.assertion = assertion;
    }

    public void setIsKernel(boolean k) {
        this.isKernel = k;
    }

    public boolean isAssertion() {
        return this.assertion;
    }

    public boolean isKernelRelation() {
        return this.isRelation() && this.isKernel;
    }

    public boolean isElement() {
        NamedElement last = this.instantiationPath.getLast();
        return last != null && last instanceof Element;
    }

    public boolean isClock() {
        NamedElement last = this.instantiationPath.getLast();
        return last != null && last instanceof Clock;
    }

    public boolean isDenseClock() {
        NamedElement last = this.instantiationPath.getLast();
        if (last == null || !(last instanceof Clock)) {
            return false;
        }
        Type type = ((Clock)last).getType();
        return type != null && type instanceof DenseClockType;
    }

    public boolean isClassicalExpression() {
        NamedElement last = this.instantiationPath.getLast();
        return last != null && last instanceof ClassicalExpression;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public Element getValue() {
        return this.value;
    }

    public void setValue(Element value) {
        this.value = value;
    }

    public boolean isPrimitiveElement() {
        NamedElement last = this.instantiationPath.getLast();
        return last != null && last instanceof PrimitiveElement;
    }

    public InstantiatedElement resolveAbstractEntity(AbstractEntity abs) {
        return this.abstractMapping.resolveAbstractEntity(abs);
    }

    public InstantiatedElement resolveAbstractEntity(String abstractName) {
        return this.abstractMapping.resolveAbstractEntity(abstractName);
    }

    public String toString() {
        String res = "";
        res = String.valueOf(res) + this.id;
        res = String.valueOf(res) + "=" + this.getQualifiedName(defaultSeparator);
        if (this.getDeclaration() != null) {
            res = String.valueOf(res) + "[" + this.getDeclaration().getName() + "]";
        }
        if (this.isConditionCase()) {
            res = this.getConditionTest() != null ? String.valueOf(res) + "|if(" + this.getConditionTest().getId() + ")" : String.valueOf(res) + "|else";
        }
        if (this.isLeaf()) {
            res = String.valueOf(res) + "^";
        }
        return res;
    }

    public void describe(PrintStream ps) {
        ps.print(this.toString());
        NamedElement decl = this.getDeclaration();
        if (decl != null) {
            ps.print('(');
            if (decl instanceof KernelRelationDeclaration) {
                AbstractEntity left = ((KernelRelationDeclaration)decl).getLeftEntity();
                ps.print(left.getName());
                ps.print("->");
                ps.print(this.getAbstractMapping().resolveAbstractEntity(left));
                ps.print(", ");
                AbstractEntity right = ((KernelRelationDeclaration)decl).getRightEntity();
                ps.print(right.getName());
                ps.print("->");
                ps.print(this.getAbstractMapping().resolveAbstractEntity(right));
            } else if (decl instanceof RelationDeclaration) {
                for (AbstractEntity param : ((RelationDeclaration)decl).getParameters()) {
                    ps.print(param.getName());
                    ps.print("->");
                    ps.print(this.getAbstractMapping().resolveAbstractEntity(param));
                    ps.print(", ");
                }
            } else if (!(decl instanceof KernelExpressionDeclaration) && decl instanceof ExpressionDeclaration) {
                for (AbstractEntity param : ((ExpressionDeclaration)decl).getParameters()) {
                    ps.print(param.getName());
                    ps.print("->");
                    ps.print(this.getAbstractMapping().resolveAbstractEntity(param));
                    ps.print(", ");
                }
            }
            ps.print(')');
        }
        ps.println();
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public void setConditional(boolean conditional) {
        this.conditional = conditional;
    }

    public List<InstantiatedElement> getConditionalCases() {
        if (this.subCases == null) {
            this.subCases = new ArrayList<InstantiatedElement>();
        }
        return this.subCases;
    }

    public void addConditionCase(InstantiatedElement element) {
        if (this.subCases == null) {
            this.subCases = new ArrayList<InstantiatedElement>();
        }
        this.subCases.add(element);
    }

    public InstantiatedElement getDefaultCase() {
        return this.defaultCase;
    }

    public boolean isRecursiveCall() {
        return this.recursiveCall;
    }

    public void setRecursiveCall(boolean recursive) {
        this.recursiveCall = recursive;
    }

    public boolean isTailRecursiveCall() {
        return this.tailRecursiveCall;
    }

    public void setTailRecursiveCall(boolean tailRecursive) {
        this.tailRecursiveCall = tailRecursive;
    }

    public long getId() {
        return this.id;
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    public InstantiationPath getBlockStack() {
        InstantiationPath res = new InstantiationPath();
        for (NamedElement elt : this.getInstantiationPath()) {
            if (!(elt instanceof Block)) break;
            res.add(elt);
        }
        return res;
    }

    public boolean equals(Object obj) {
        return obj instanceof InstantiatedElement && this.instantiationPath.equals(((InstantiatedElement)obj).getInstantiationPath());
    }

    public long getUseCount() {
        return this.useCount;
    }

    public synchronized void incUseCount() {
        ++this.useCount;
    }

    public synchronized void decUseCount() {
        --this.useCount;
    }

    public boolean isConditionCase() {
        return this.conditionCase;
    }

    public void setConditionCase(boolean conditionalCase) {
        this.conditionCase = conditionalCase;
    }

    public boolean inConditionalBranch() {
        if (this.isConditionCase()) {
            return true;
        }
        if (this.parent == null) {
            return this.isConditionCase();
        }
        return this.parent.inConditionalBranch();
    }

    public InstantiatedElement getConditionTest() {
        return this.conditionTest;
    }

    public void setConditionTest(InstantiatedElement conditionTest) {
        this.conditionTest = conditionTest;
    }

    public void setDefaultCase(InstantiatedElement defaultCase) {
        this.defaultCase = defaultCase;
    }

    public List<InstantiatedElement> getBranchConditionTests() {
        List<Object> res = this.parent == null ? new ArrayList() : this.parent.getBranchConditionTests();
        if (this.isConditionCase() && this.conditionTest != null) {
            res.add(this.conditionTest);
        }
        return res;
    }

    public InstantiatedElement getParent() {
        return this.parent;
    }

    public void setParent(InstantiatedElement parent) {
        this.parent = parent;
        parent.addSon(this);
    }

    private void addSon(InstantiatedElement son) {
        if (this.sons == null) {
            this.sons = new ArrayList<InstantiatedElement>();
        }
        this.sons.add(son);
    }

    public List<InstantiatedElement> getSons() {
        return this.sons;
    }
}

