/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.widgets;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationMessages;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterRule;

final class OnEnterRuleTableWidget
extends TableViewer {
    OnEnterRuleTableWidget(Table table) {
        super(table);
        this.setContentProvider((IContentProvider)new OnEnterRuleContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new OnEnterRuleLabelProvider());
        GC gc = new GC((Drawable)table.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumnLayout columnLayout = new TableColumnLayout();
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(LanguageConfigurationMessages.OnEnterRuleTableWidget_beforeText);
        int minWidth = this.computeMinimumColumnWidth(gc, LanguageConfigurationMessages.OnEnterRuleTableWidget_beforeText);
        columnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(LanguageConfigurationMessages.OnEnterRuleTableWidget_afterText);
        minWidth = this.computeMinimumColumnWidth(gc, LanguageConfigurationMessages.OnEnterRuleTableWidget_afterText);
        columnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(LanguageConfigurationMessages.OnEnterRuleTableWidget_indentAction);
        minWidth = this.computeMinimumColumnWidth(gc, LanguageConfigurationMessages.OnEnterRuleTableWidget_indentAction);
        columnLayout.setColumnData((Widget)column3, (ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        TableColumn column4 = new TableColumn(table, 0);
        column4.setText(LanguageConfigurationMessages.OnEnterRuleTableWidget_appendText);
        minWidth = this.computeMinimumColumnWidth(gc, LanguageConfigurationMessages.OnEnterRuleTableWidget_appendText);
        columnLayout.setColumnData((Widget)column4, (ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        TableColumn column5 = new TableColumn(table, 0);
        column5.setText(LanguageConfigurationMessages.OnEnterRuleTableWidget_removeText);
        minWidth = this.computeMinimumColumnWidth(gc, LanguageConfigurationMessages.OnEnterRuleTableWidget_removeText);
        columnLayout.setColumnData((Widget)column5, (ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        gc.dispose();
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    private static final class OnEnterRuleContentProvider
    implements IStructuredContentProvider {
        private List<OnEnterRule> onEnterRulesList = Collections.emptyList();

        private OnEnterRuleContentProvider() {
        }

        public Object[] getElements(@Nullable Object input) {
            assert (this.onEnterRulesList != null);
            return this.onEnterRulesList.toArray(OnEnterRule[]::new);
        }

        public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
            this.onEnterRulesList = newInput == null ? Collections.emptyList() : (List)newInput;
        }

        public void dispose() {
            this.onEnterRulesList = Collections.emptyList();
        }
    }

    private static final class OnEnterRuleLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private OnEnterRuleLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            return null;
        }

        public @Nullable String getText(@Nullable Object element) {
            return this.getColumnText(element, 0);
        }

        public @Nullable String getColumnText(@Nullable Object element, int columnIndex) {
            if (element == null) {
                return "";
            }
            OnEnterRule rule = (OnEnterRule)element;
            EnterAction action = rule.getAction();
            switch (columnIndex) {
                case 0: {
                    Pattern beforeText = rule.getBeforeText();
                    return beforeText == null ? "" : beforeText.pattern();
                }
                case 1: {
                    Pattern afterText = rule.getAfterText();
                    return afterText == null ? "" : afterText.pattern();
                }
                case 2: {
                    return action.getIndentAction().toString();
                }
                case 3: {
                    String appendText = action.getAppendText();
                    return appendText == null ? "" : appendText;
                }
                case 4: {
                    Integer removeText = action.getRemoveText();
                    return removeText == null ? "" : removeText.toString();
                }
            }
            return "";
        }
    }
}

