/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.supports.AutoClosingPairConditional;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.Comments;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.supports.Folding;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterRule;

public final class LanguageConfiguration
implements ILanguageConfiguration {
    private @Nullable Comments comments;
    private @Nullable List<CharacterPair> brackets;
    private @Nullable List<OnEnterRule> onEnterRules;
    private @Nullable List<AutoClosingPairConditional> autoClosingPairs;
    private @Nullable List<CharacterPair> surroundingPairs;
    private @Nullable Folding folding;
    private @Nullable String wordPattern;

    public static @Nullable LanguageConfiguration load(Reader reader) {
        return (LanguageConfiguration)new GsonBuilder().registerTypeAdapter(OnEnterRule.class, (json, typeOfT, context) -> {
            String beforeText = null;
            String afterText = null;
            EnterAction action = null;
            if (json.isJsonObject()) {
                JsonObject actionObject;
                String indentActionString;
                JsonObject object = json.getAsJsonObject();
                beforeText = LanguageConfiguration.getAsString(object.get("beforeText"));
                afterText = LanguageConfiguration.getAsString(object.get("afterText"));
                JsonElement actionElement = object.get("action");
                if (actionElement != null && actionElement.isJsonObject() && (indentActionString = LanguageConfiguration.getAsString((actionObject = actionElement.getAsJsonObject()).get("indentAction"))) != null) {
                    EnterAction.IndentAction indentAction = EnterAction.IndentAction.valueOf(indentActionString);
                    Integer removeText = LanguageConfiguration.getAsInteger(actionObject.get("removeText"));
                    String appendText = LanguageConfiguration.getAsString(actionObject.get("appendText"));
                    action = new EnterAction(indentAction);
                    action.setAppendText(appendText);
                    action.setRemoveText(removeText);
                }
            }
            if (beforeText == null || action == null) {
                return null;
            }
            return new OnEnterRule(beforeText, afterText, action);
        }).registerTypeAdapter(Comments.class, (json, typeOfT, context) -> {
            String lineComment = null;
            CharacterPair blockComment = null;
            if (json.isJsonObject()) {
                JsonArray blockCommentArray;
                JsonObject object = json.getAsJsonObject();
                lineComment = LanguageConfiguration.getAsString(object.get("lineComment"));
                JsonElement blockCommentElement = object.get("blockComment");
                if (blockCommentElement != null && blockCommentElement.isJsonArray() && (blockCommentArray = blockCommentElement.getAsJsonArray()).size() == 2) {
                    String blockCommentStart = LanguageConfiguration.getAsString(blockCommentArray.get(0));
                    String blockCommentEnd = LanguageConfiguration.getAsString(blockCommentArray.get(1));
                    if (blockCommentStart != null && blockCommentEnd != null) {
                        blockComment = new CharacterPair(blockCommentStart, blockCommentEnd);
                    }
                }
            }
            if (lineComment == null && blockComment == null) {
                return null;
            }
            return new Comments(lineComment, blockComment);
        }).registerTypeAdapter(CharacterPair.class, (json, typeOfT, context) -> {
            JsonArray characterPairs;
            String open = null;
            String close = null;
            if (json.isJsonArray() && (characterPairs = json.getAsJsonArray()).size() == 2) {
                open = LanguageConfiguration.getAsString(characterPairs.get(0));
                close = LanguageConfiguration.getAsString(characterPairs.get(1));
            }
            if (open == null || close == null) {
                return null;
            }
            return new CharacterPair(open, close);
        }).registerTypeAdapter(AutoClosingPairConditional.class, (json, typeOfT, context) -> {
            ArrayList<String> notInList = new ArrayList<String>();
            String open = null;
            String close = null;
            if (json.isJsonArray()) {
                JsonArray characterPairs = json.getAsJsonArray();
                if (characterPairs.size() == 2) {
                    open = LanguageConfiguration.getAsString(characterPairs.get(0));
                    close = LanguageConfiguration.getAsString(characterPairs.get(1));
                }
            } else if (json.isJsonObject()) {
                JsonObject object = json.getAsJsonObject();
                open = LanguageConfiguration.getAsString(object.get("open"));
                close = LanguageConfiguration.getAsString(object.get("close"));
                JsonElement notInElement = object.get("notIn");
                if (notInElement != null && notInElement.isJsonArray()) {
                    JsonArray notInArray = notInElement.getAsJsonArray();
                    notInArray.forEach(element -> {
                        String string = LanguageConfiguration.getAsString(element);
                        if (string != null) {
                            notInList.add(string);
                        }
                    });
                }
            }
            if (open == null || close == null) {
                return null;
            }
            return new AutoClosingPairConditional(open, close, notInList);
        }).registerTypeAdapter(Folding.class, (json, typeOfT, context) -> {
            boolean offSide = false;
            String startMarker = null;
            String endMarker = null;
            if (json.isJsonObject()) {
                JsonObject object = json.getAsJsonObject();
                offSide = LanguageConfiguration.getAsBoolean(object.get("offSide"), offSide);
                JsonElement markersElement = object.get("markers");
                if (markersElement != null && markersElement.isJsonObject()) {
                    JsonObject markersObject = markersElement.getAsJsonObject();
                    startMarker = LanguageConfiguration.getAsString(markersObject.get("start"));
                    endMarker = LanguageConfiguration.getAsString(markersObject.get("end"));
                }
            }
            if (startMarker == null || endMarker == null) {
                return null;
            }
            return new Folding(offSide, startMarker, endMarker);
        }).create().fromJson(reader, LanguageConfiguration.class);
    }

    private static @Nullable String getAsString(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        try {
            return element.getAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean getAsBoolean(@Nullable JsonElement element, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        try {
            return element.getAsBoolean();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static @Nullable Integer getAsInteger(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        try {
            return element.getAsInt();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public @Nullable Comments getComments() {
        return this.comments;
    }

    @Override
    public @Nullable List<CharacterPair> getBrackets() {
        return this.brackets;
    }

    @Override
    public @Nullable List<AutoClosingPairConditional> getAutoClosingPairs() {
        return this.autoClosingPairs;
    }

    @Override
    public @Nullable List<OnEnterRule> getOnEnterRules() {
        return this.onEnterRules;
    }

    @Override
    public @Nullable List<CharacterPair> getSurroundingPairs() {
        return this.surroundingPairs;
    }

    @Override
    public @Nullable Folding getFolding() {
        return this.folding;
    }

    @Override
    public @Nullable String getWordPattern() {
        return this.wordPattern;
    }
}

