/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.relations;

import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.INamedElement;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IRuntimeContainer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.QualifiedName;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractRuntimeRelation
extends AbstractConstraint
implements ICCSLConstraint,
IRuntimeContainer,
INamedElement {
    private String name;
    private QualifiedName qualifiedName;
    private boolean isAssertion;
    private int assertionVariableNumber;
    private IRuntimeContainer parent;
    private List<IRuntimeContainer> contents = new ArrayList<IRuntimeContainer>();
    private List<RuntimeClock> discreteClocks = new ArrayList<RuntimeClock>();
    private List<RuntimeClock> denseClocks = new ArrayList<RuntimeClock>();
    private List<AbstractRuntimeRelation> relations = new ArrayList<AbstractRuntimeRelation>();
    private List<AbstractRuntimeExpression> expressions = new ArrayList<AbstractRuntimeExpression>();

    public AbstractRuntimeRelation() {
        this.isAssertion = false;
    }

    public AbstractRuntimeRelation(String name) {
        this.name = name;
        this.isAssertion = false;
    }

    protected abstract ICCSLConstraint[] getConstraints();

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (this.canCallStart()) {
            super.startTransition();
        }
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallSemantic()) {
            return;
        }
        super.semanticTransition();
        if (this.isAssertion) {
            this.assertionSemantic(helper);
            helper.registerAssertion(this);
        }
    }

    public abstract void assertionSemantic(AbstractSemanticHelper var1);

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (this.canCallUpdate()) {
            super.updateTransition();
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
    }

    @Override
    public boolean canCallTerminate() {
        return false;
    }

    @Override
    public void terminate(AbstractUpdateHelper helper) throws SimulationException {
        if (this.canCallTerminate()) {
            super.terminateTransition();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = new QualifiedName(qualifiedName);
    }

    @Override
    public void setQualifiedName(QualifiedName qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Override
    public QualifiedName getQualifiedName() {
        if (this.qualifiedName != null) {
            return this.qualifiedName;
        }
        if (this.parent != null && this.parent instanceof INamedElement) {
            QualifiedName qname = new QualifiedName(((INamedElement)((Object)this.parent)).getQualifiedName());
            qname.append(this.getName());
            this.qualifiedName = qname;
            return qname;
        }
        return new QualifiedName(this.getName());
    }

    @Override
    public IRuntimeContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IRuntimeContainer parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addContent(this);
        }
    }

    @Override
    public void addContent(IRuntimeContainer element) {
        if (element instanceof RuntimeClock) {
            if (((RuntimeClock)element).isDense()) {
                this.denseClocks.add((RuntimeClock)element);
            } else {
                this.discreteClocks.add((RuntimeClock)element);
            }
        } else if (element instanceof AbstractRuntimeRelation) {
            this.relations.add((AbstractRuntimeRelation)element);
        } else if (element instanceof AbstractRuntimeExpression) {
            this.expressions.add((AbstractRuntimeExpression)element);
        }
        this.contents.add(element);
    }

    public List<RuntimeClock> getDiscreteClocks() {
        ArrayList<RuntimeClock> res = new ArrayList<RuntimeClock>(this.discreteClocks);
        for (AbstractRuntimeRelation relation : this.relations) {
            res.addAll(relation.getDiscreteClocks());
        }
        for (AbstractRuntimeExpression expression : this.expressions) {
            res.addAll(expression.getDiscreteClocks());
        }
        return res;
    }

    public Collection<? extends AbstractRuntimeRelation> getAllAssertions() {
        ArrayList<? extends AbstractRuntimeRelation> res = new ArrayList<AbstractRuntimeRelation>();
        for (AbstractRuntimeRelation relation : this.relations) {
            if (!relation.isAssertion) continue;
            res.add(relation);
            res.addAll(relation.getAllAssertions());
        }
        return res;
    }

    @Override
    public List<IRuntimeContainer> getContents() {
        return this.contents;
    }

    public void setAssertion(boolean isAssertion) {
        this.isAssertion = isAssertion;
    }

    public boolean isAssertion() {
        return this.isAssertion;
    }

    public int getAssertionVariable() {
        return this.assertionVariableNumber;
    }

    public void setAssertionVariable(int assertionVariableNumber) {
        this.assertionVariableNumber = assertionVariableNumber;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public SerializedConstraintState dumpState() {
        return new SerializedConstraintState();
    }

    @Override
    public void restoreState(SerializedConstraintState state) {
    }
}

