/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;

public class RuntimeUpTo
extends AbstractRuntimeExpression {
    private RuntimeClock clockToFollow;
    private RuntimeClock killerClock;
    private boolean isPreemptive = true;

    public RuntimeUpTo(RuntimeClock iClock, RuntimeClock clockToFollow, RuntimeClock killerClock) {
        super(iClock);
        this.clockToFollow = clockToFollow;
        this.killerClock = killerClock;
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (this.clockToFollow instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clockToFollow)).semantic(helper);
        }
        if (this.killerClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.killerClock)).semantic(helper);
        }
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.state == AbstractConstraint.State.DEAD) {
            helper.inhibitClock(this.getExpressionClock());
        } else if (this.isPreemptive) {
            helper.semanticBDDAnd(helper.createEqual(this.getExpressionClock(), helper.createIntersection(this.getClockToFollow(), helper.createNot(this.getKillerClock()))));
        } else {
            helper.semanticBDDAnd(helper.createEqual(this.getExpressionClock(), this.getClockToFollow()));
        }
        helper.registerClockUse(new RuntimeClock[]{this.getExpressionClock(), this.getClockToFollow(), this.getKillerClock()});
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.clockToFollow instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clockToFollow)).deathSemantic(helper);
        }
        if (this.killerClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.killerClock)).deathSemantic(helper);
        }
        helper.registerDeathImplication(this.clockToFollow, this.getExpressionClock());
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (this.clockToFollow instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clockToFollow)).update(helper);
        }
        if (this.killerClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.killerClock)).update(helper);
        }
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(helper);
        if (helper.clockHasFired(this.killerClock)) {
            this.terminate(helper);
        }
    }

    public RuntimeClock getClockToFollow() {
        return this.clockToFollow;
    }

    public RuntimeClock getKillerClock() {
        return this.killerClock;
    }

    public void setPreemptive(boolean isPreemptive) {
        this.isPreemptive = isPreemptive;
    }
}

