/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view.figure;

import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import fr.inria.aoste.timesquare.vcd.view.figure.CountFigure;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class DrawTimer
extends Polygon
implements ExtendFigure {
    private String labelvalue = "Active";
    private int length;
    protected int oldvalue = 0;
    private Point tr = new Point(0, 0);
    private VcdFactory _vcdFactory;
    private int x;
    private int y;
    Label label = null;
    private ExtendFigure.Level precedeLevel;
    private ExtendFigure.Level futurLevel;

    public DrawTimer(VcdFactory vcd, int x, int y, int length, String label) {
        this._vcdFactory = vcd;
        this.x = x;
        this.y = y;
        this.length = length;
        this.labelvalue = label;
        CountFigure.inc();
    }

    @Override
    public int incLength(int l) {
        this.length += l;
        return this.length;
    }

    public String getLabelvalue() {
        return this.labelvalue;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Point getTr() {
        return this.tr;
    }

    @Override
    public boolean isGhost() {
        return false;
    }

    @Override
    public int mycompute() {
        double zoom = 1.0;
        int x2 = this.x + this.length;
        int mx = this.x;
        int mx2 = x2;
        if (this._vcdFactory.getVcdZoom() != null) {
            mx = this._vcdFactory.getVcdZoom().computeposition(this.x);
            mx2 = this._vcdFactory.getVcdZoom().computeposition(x2);
        }
        this.setPoints(new PointList());
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.setOpaque(false);
        this.setForegroundColor(this._vcdFactory.getMca().colorTimer());
        this.addPoint(new Point(mx + 2, this.y + this._vcdFactory.getHeight()).translate(this.tr));
        this.addPoint(new Point(mx, this.y + this._vcdFactory.getHalfHeight()).translate(this.tr));
        this.addPoint(new Point(mx + 2, this.y).translate(this.tr));
        this.addPoint(new Point(mx2 - 2, this.y).translate(this.tr));
        this.addPoint(new Point(mx2, this.y + this._vcdFactory.getHalfHeight()).translate(this.tr));
        this.addPoint(new Point(mx2 - 2, this.y + this._vcdFactory.getHeight()).translate(this.tr));
        if (this.label == null) {
            this.label = new Label("Active");
        }
        this.add((IFigure)this.label, BorderLayout.CENTER);
        this.label.setForegroundColor(this._vcdFactory.getMca().colorTimerText());
        this.label.setBounds(new Rectangle(new Point(mx, this.y).translate(this.tr), new Dimension((int)((double)this.length * zoom), this._vcdFactory.getHeight())));
        return 0;
    }

    public void setLabelvalue(String labelvalue) {
        this.labelvalue = labelvalue;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setoldValue(int n) {
        this.oldvalue = n;
    }

    @Override
    public void setTr(Point tr) {
        this.tr = tr;
    }

    @Override
    public ExtendFigure.Level getLevel() {
        return ExtendFigure.Level.time;
    }

    @Override
    public final ExtendFigure.Level getPrecedeLevel() {
        return this.precedeLevel;
    }

    @Override
    public final void setPrecedeLevel(ExtendFigure.Level precedeLevel) {
        this.precedeLevel = precedeLevel;
    }

    @Override
    public final ExtendFigure.Level getFuturLevel() {
        return this.futurLevel;
    }

    @Override
    public final void setFuturLevel(ExtendFigure.Level futurLevel) {
        this.futurLevel = futurLevel;
    }

    protected void finalize() throws Throwable {
        CountFigure.dec();
        super.finalize();
    }
}

