/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model;

import fr.inria.aoste.timesquare.vcd.label.DefaultTimeLabelling;
import fr.inria.aoste.timesquare.vcd.label.ITimeLabelling;
import fr.inria.aoste.timesquare.vcd.model.ClockListener;
import fr.inria.aoste.timesquare.vcd.model.Comment;
import fr.inria.aoste.timesquare.vcd.model.CommentArrayList;
import fr.inria.aoste.timesquare.vcd.model.ICommentCommand;
import fr.inria.aoste.timesquare.vcd.model.IDeclarationCommand;
import fr.inria.aoste.timesquare.vcd.model.ISimulationCommand;
import fr.inria.aoste.timesquare.vcd.model.command.ScopeCommand;
import fr.inria.aoste.timesquare.vcd.model.command.TimeScaleCommand;
import fr.inria.aoste.timesquare.vcd.model.comment.ConstraintCommentCommand;
import fr.inria.aoste.timesquare.vcd.model.comment.DecodeDictionary;
import fr.inria.aoste.timesquare.vcd.model.comment.IConstraintData;
import fr.inria.aoste.timesquare.vcd.model.comment.IDecodeComment;
import fr.inria.aoste.timesquare.vcd.model.comment.ModelRelationComment;
import fr.inria.aoste.timesquare.vcd.model.comment.StatusCommentCommand;
import fr.inria.aoste.timesquare.vcd.model.visitor.IDeclarationVisitor;
import fr.inria.aoste.timesquare.vcd.model.visitor.IScopeVisitor;
import fr.inria.aoste.timesquare.vcd.model.visitor.ISimulationCollector;
import fr.inria.aoste.timesquare.vcd.model.visitor.StringVisitor;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;

public final class VCDDefinitions {
    private ClockListener _clocklistener = new ClockListener();
    private ScopeCommand _scopeCommand = null;
    private ArrayList<IDeclarationCommand> _arraylistDeclarationCommand = new ArrayList();
    private int _pulse = -1;
    private ArrayList<ISimulationCommand> _arraylistSimulationCommand = new ArrayList();
    private int _offSet = -1;
    private VcdFactory _vcdFactory = null;
    ITimeLabelling _timeLabelling = new DefaultTimeLabelling();
    ArrayList<IConstraintData> _constraintList = new ArrayList();
    IContainer _vcdFolder;

    public VCDDefinitions() {
        this._timeLabelling.setVcdDefinitions(this);
    }

    public final VcdFactory getFactory() {
        return this._vcdFactory;
    }

    public void setScope(ScopeCommand scopeCommand) {
        this._scopeCommand = scopeCommand;
        if (scopeCommand != null) {
            this._clocklistener.add(scopeCommand);
            scopeCommand.setClockListener(this._clocklistener);
        }
    }

    public void addDefinition(IDeclarationCommand declarationCommand) {
        if (declarationCommand != null) {
            this._arraylistDeclarationCommand.add(declarationCommand);
            if (declarationCommand instanceof ICommentCommand) {
                this._clocklistener.add((ICommentCommand)declarationCommand);
                ((ICommentCommand)declarationCommand).validate(this);
            }
        }
    }

    public final void setFactory(VcdFactory vcdFactory) {
        this._vcdFactory = vcdFactory;
        if (vcdFactory != null && this._constraintList != null) {
            for (IConstraintData _constraintData : this._constraintList) {
                if (_constraintData.getConstraints() == null) continue;
                if (_constraintData.getConstraints().getIcc() == null) {
                    _constraintData.getConstraints().setIcc(vcdFactory.getConstraintsFactory());
                }
                if (_constraintData.getConstraints().getList() != null) continue;
                _constraintData.getConstraints().setList(vcdFactory.getVcddia().getListConnections());
            }
        }
    }

    public void addSimulation(ISimulationCommand simulationCommand) {
        this._arraylistSimulationCommand.add(simulationCommand);
    }

    public Object visit(StringVisitor stringVisitor) {
        ISimulationCollector simulationVisitor;
        IScopeVisitor scopeVisitor;
        IDeclarationVisitor declarationVisitor = stringVisitor.getDeclarationVisitor();
        if (declarationVisitor != null) {
            this.visit(declarationVisitor);
        }
        if ((scopeVisitor = stringVisitor.getScopeVisitor()) != null) {
            this.visit(scopeVisitor);
        }
        if (declarationVisitor != null) {
            declarationVisitor.visitEndDefinitions();
        }
        if ((simulationVisitor = stringVisitor.getSimulationVisitor()) != null) {
            this.visit(simulationVisitor);
        }
        return stringVisitor;
    }

    public void visit(IDeclarationVisitor visitor) {
        if (visitor == null) {
            return;
        }
        for (IDeclarationCommand dc : this._arraylistDeclarationCommand) {
            dc.visit(visitor);
        }
    }

    public void visit(IScopeVisitor visitor) {
        if (this._scopeCommand == null) {
            throw new RuntimeException("VCD without scope");
        }
        this._scopeCommand.visit(visitor);
    }

    public void visit(ISimulationCollector simulationCollector) {
        for (ISimulationCommand sc : this._arraylistSimulationCommand) {
            sc.visit(simulationCollector);
        }
        simulationCollector.endSimulation();
    }

    public void visit(ISimulationCollector collector, int n1, int n2, boolean b) {
        int n = this._arraylistSimulationCommand.size();
        n2 = n2 < n ? n2 : n;
        int i = n1;
        while (i < n2) {
            this._arraylistSimulationCommand.get(i).visit(collector);
            ++i;
        }
        if (b) {
            collector.endSimulation();
        }
    }

    public ArrayList<StatusCommentCommand> getStatusCommentCommand() {
        ArrayList<StatusCommentCommand> _arraylistStatusCommentCommand = new ArrayList<StatusCommentCommand>();
        for (IDeclarationCommand _dc : this._arraylistDeclarationCommand) {
            if (!(_dc instanceof StatusCommentCommand)) continue;
            _arraylistStatusCommentCommand.add((StatusCommentCommand)_dc);
        }
        return _arraylistStatusCommentCommand;
    }

    public ArrayList<ConstraintCommentCommand> getConstraintCommentCommand() {
        ArrayList<ConstraintCommentCommand> commands = new ArrayList<ConstraintCommentCommand>();
        for (IDeclarationCommand _dc : this._arraylistDeclarationCommand) {
            if (!(_dc instanceof ConstraintCommentCommand)) continue;
            commands.add((ConstraintCommentCommand)_dc);
        }
        return commands;
    }

    public TimeScaleCommand getTimeScaleCommand() {
        for (IDeclarationCommand _dc : this._arraylistDeclarationCommand) {
            if (!(_dc instanceof TimeScaleCommand)) continue;
            return (TimeScaleCommand)_dc;
        }
        return null;
    }

    public int getPulse() {
        return this._pulse;
    }

    public void setPulse(int pulse) {
        this._pulse = pulse;
    }

    public int getOffSet() {
        return this._offSet;
    }

    public void setOffSet(int offset) {
        this._offSet = offset;
    }

    public ArrayList<IDeclarationCommand> getArraylistDeclarationCommand() {
        return this._arraylistDeclarationCommand;
    }

    public ArrayList<ISimulationCommand> getArraylistSimulationCommand() {
        return this._arraylistSimulationCommand;
    }

    public String getVCDString() {
        return this.visit(new StringVisitor()).toString();
    }

    public VCDDefinitions cloneWithNewFactory(VcdFactory vcdFactory) {
        VCDDefinitions vcdnew = new VCDDefinitions();
        vcdnew.setFactory(vcdFactory);
        vcdnew.setOffSet(this._offSet);
        vcdnew.setPulse(this._pulse);
        vcdnew.setScope(this._scopeCommand);
        vcdnew._arraylistDeclarationCommand = new ArrayList();
        for (IDeclarationCommand _dc : this._arraylistDeclarationCommand) {
            vcdnew._arraylistDeclarationCommand.add(_dc);
        }
        vcdnew._arraylistSimulationCommand = new ArrayList();
        for (ISimulationCommand _sc : this._arraylistSimulationCommand) {
            vcdnew._arraylistSimulationCommand.add(_sc.cloneCommand());
        }
        return vcdnew;
    }

    public ICommentCommand createComment(String commentID) {
        IDecodeComment _decodeComment = DecodeDictionary.getDefault().getDecoder(commentID);
        if (_decodeComment == null) {
            System.err.println("comment unknow");
            return null;
        }
        ICommentCommand _commentCommand = _decodeComment.createEmpty();
        this.addDefinition(_commentCommand);
        return _commentCommand;
    }

    public ICommentCommand createComment(String commentID, String value) {
        IDecodeComment _decodeComment = DecodeDictionary.getDefault().getDecoder(commentID);
        if (_decodeComment == null) {
            System.err.println("comment unknow");
            return null;
        }
        Comment _comment = new Comment(String.valueOf(commentID) + " " + value, null);
        ICommentCommand _commentCommand = _decodeComment.create(_comment);
        this.addDefinition(_commentCommand);
        return _commentCommand;
    }

    public ICommentCommand createCommentClock(String commentID, String clockName) {
        IDecodeComment _decodeComment = DecodeDictionary.getDefault().getDecoder(commentID);
        if (_decodeComment == null) {
            System.err.println("comment unknow");
            return null;
        }
        ICommentCommand commentCommand = _decodeComment.createEmpty();
        commentCommand.setClockLink(clockName);
        this.addDefinition(commentCommand);
        return commentCommand;
    }

    public ICommentCommand createCommentTick(String commentID, Object tick) {
        IDecodeComment decodeComment = DecodeDictionary.getDefault().getDecoder(commentID);
        if (decodeComment == null) {
            System.err.println("comment unknow");
            return null;
        }
        ICommentCommand commentCommand = decodeComment.createEmpty();
        return commentCommand;
    }

    public int setCommentCommand(ICommentCommand commentCommand, String s) {
        if (commentCommand == null) {
            return 0;
        }
        CommentArrayList commentArraylist = this.array(s, "");
        int i = 1;
        for (String _str : commentArraylist) {
            commentCommand.setString(i++, _str);
        }
        commentCommand.update(s, commentArraylist);
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private CommentArrayList array(String s, String init) {
        parts = new CommentArrayList();
        if (init != null) {
            parts.add(init);
        }
        if (s == null) {
            return parts;
        }
        if (s.length() == 0) {
            return parts;
        }
        cs = s.replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ");
        r = null;
        while (!cs.equals(r)) {
            r = cs;
            cs = cs.replaceAll("  ", " ");
        }
        if (cs.length() != 0) ** GOTO lbl18
        return parts;
lbl-1000:
        // 1 sources

        {
            cs = cs.substring(1);
lbl18:
            // 2 sources

            ** while (cs.charAt((int)0) == ' ')
        }
lbl19:
        // 1 sources

        var10_7 = st = cs.split(" ");
        var9_8 = st.length;
        var8_9 = 0;
        while (var8_9 < var9_8) {
            _s = var10_7[var8_9];
            if (_s != null) {
                parts.add(_s);
            }
            ++var8_9;
        }
        return parts;
    }

    public final ClockListener getClocklistener() {
        return this._clocklistener;
    }

    public ModelRelationComment getModelRelationComment() {
        for (IDeclarationCommand mrc : this._arraylistDeclarationCommand) {
            if (!(mrc instanceof ModelRelationComment)) continue;
            return (ModelRelationComment)mrc;
        }
        return null;
    }

    public int addContraint(IConstraintData icd) {
        if (this._constraintList != null && !this._constraintList.contains(icd)) {
            this._constraintList.add(icd);
            if (icd.getConstraints() != null && this._vcdFactory != null) {
                if (icd.getConstraints().getIcc() == null) {
                    icd.getConstraints().setIcc(this._vcdFactory.getConstraintsFactory());
                }
                if (icd.getConstraints().getList() == null && this._vcdFactory.getVcddia() != null) {
                    icd.getConstraints().setList(this._vcdFactory.getVcddia().getListConnections());
                }
            }
        }
        return 0;
    }

    public final ArrayList<IConstraintData> getConstraintList() {
        return this._constraintList;
    }

    public final IContainer getVcdfolder() {
        return this._vcdFolder;
    }

    public final void setVcdfolder(IContainer vcdfolder) {
        this._vcdFolder = vcdfolder;
        for (IDeclarationCommand _decl : this._arraylistDeclarationCommand) {
            if (!(_decl instanceof ICommentCommand)) continue;
            ((ICommentCommand)_decl).validate(this);
        }
    }

    public void setTimeLabelling(ITimeLabelling timeLabelling) {
        this._timeLabelling = timeLabelling;
    }

    public ITimeLabelling getTimeLabelling() {
        return this._timeLabelling;
    }
}

