/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.model.IComment;
import fr.inria.aoste.timesquare.vcd.model.ICommentCommand;
import fr.inria.aoste.timesquare.vcd.model.Uposition;
import fr.inria.aoste.timesquare.vcd.model.comment.DecodeDictionary;
import fr.inria.aoste.timesquare.vcd.model.comment.IDecodeComment;
import java.util.ArrayList;

public class Comment
implements IComment {
    private StringBuffer _complete;
    private Uposition _up = null;
    private ArrayList<String> _parts = new ArrayList();

    public int getTime() {
        return 0;
    }

    public void addPart(String part) {
        this._parts.add(part);
        this._complete.append(' ').append(part);
    }

    private void array(String s) {
        String[] st;
        String cs = s.replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ");
        String r = null;
        while (!cs.equals(r)) {
            r = cs;
            cs = cs.replaceAll("  ", " ");
        }
        while (cs.charAt(0) == ' ') {
            cs = cs.substring(1);
        }
        String[] stringArray = st = cs.split(" ");
        int n = st.length;
        int n2 = 0;
        while (n2 < n) {
            String _s = stringArray[n2];
            if (_s != null) {
                this._parts.add(_s);
            }
            ++n2;
        }
    }

    public Comment(String start, Uposition up) {
        this._complete = new StringBuffer(start);
        if (start.contains(" ")) {
            this.array(start);
        } else {
            this._parts.add(start);
        }
        this._up = up;
        if (this._up == null) {
            this._up = new Uposition(0, null);
        }
    }

    @Override
    public int nbParts() {
        return this._parts.size();
    }

    @Override
    public String get(int pos) {
        return this._parts.get(pos);
    }

    public ICommentCommand convert() {
        try {
            IDecodeComment idc = DecodeDictionary.getDefault().getDecoder(this._parts.get(0));
            if (idc != null) {
                ICommentCommand x = idc.create(this);
                if (x != null) {
                    x.validate();
                }
                return x;
            }
            return null;
        }
        catch (Throwable ex) {
            ErrorConsole.printError((Throwable)ex, (String)(" :" + this._parts.get(0)));
            return null;
        }
    }

    public String toString() {
        return "Other : " + this._complete + " @ " + this._up;
    }

    public String getComment() {
        return this._complete.toString();
    }
}

