/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.preferences;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecoretools.ale.ide.project.AleProjectPreferences;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.emf.ecoretools.ale.ide.ui.preferences.AbstractPropertyPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.osgi.service.prefs.BackingStoreException;

public class AleEnvironmentPropertyPage
extends AbstractPropertyPage {
    public static final String CORE_PLUGIN_ID = "org.eclipse.emf.ecoretools.ale.core";
    private static final boolean IS_CONFIGURED_FROM_A_DSL_FILE_BY_DEFAULT = false;
    private static final String DEFAULT_DSL_FILE_PATH = "";
    private static final String DEFAULT_ALE_SOURCE_FILES = "";
    private static final String DEFAULT_ECORE_MODEL_FILES = "";
    private IEclipsePreferences preferences;
    private Button configureFromDslFileRadioButton;
    private Text dslFilePathText;
    private Button configureFromProjectPreferencesRadioButton;
    private Text aleSourceFilesPathText;
    private Text ecoreModelsPathText;

    protected Control createContents(Composite parent) {
        if (!this.resolveCurrentProject()) {
            Activator.warn("Cannot create the 'ALE Environment' property page: failed to resolve current project", null);
            return new Composite(parent, 0);
        }
        ProjectScope context = new ProjectScope(this.project);
        this.preferences = context.getNode(CORE_PLUGIN_ID);
        Composite container = new Composite(parent, 4);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(768));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        try {
            this.createPageDescription(container, 3);
            AleEnvironmentPropertyPage.addSeparator(container, 3);
            this.createConfigureFromPreferencesGroup(container);
            this.createConfigureFromDslFileGroup(container);
        }
        catch (Exception e) {
            Activator.error("An error occurred while created the 'ALE Environment' property page", e);
        }
        return container;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.configureFromDslFileRadioButton.setSelection(false);
        this.dslFilePathText.setText("");
        this.configureFromProjectPreferencesRadioButton.setSelection(true);
        this.aleSourceFilesPathText.setText("");
        this.ecoreModelsPathText.setText("");
    }

    public boolean performOk() {
        try {
            this.preferences.putBoolean(AleProjectPreferences.CONFIGURED_FROM_DSL_FILE.property(), this.configureFromDslFileRadioButton.getSelection());
            this.preferences.put(AleProjectPreferences.DSL_FILE_PATH.property(), this.dslFilePathText.getText().trim());
            this.preferences.put(AleProjectPreferences.ALE_SOURCE_FILES.property(), this.aleSourceFilesPathText.getText().trim());
            this.preferences.put(AleProjectPreferences.ECORE_MODEL_FILES.property(), this.ecoreModelsPathText.getText().trim());
            this.preferences.flush();
        }
        catch (IllegalStateException | BackingStoreException unlikelyToHappen) {
            Activator.error("An unexpected error occurred while saving preferences", unlikelyToHappen);
            return false;
        }
        return true;
    }

    private void createPageDescription(Composite container, int numColumns) {
        String description = "Configure sources and metamodels in path. Affects editors, compilers and interpreters.\nSee the documentation for further details.";
        StyledText linkToDocumentation = AleEnvironmentPropertyPage.createLink(container, description, "http://gemoc.org/ale-lang", description.indexOf("See"), description.length() - description.indexOf("See") - 1);
        GridDataFactory.fillDefaults().span(numColumns, 1).grab(true, false).applyTo((Control)linkToDocumentation);
    }

    private void createConfigureFromPreferencesGroup(Composite container) {
        int numColumns = 3;
        this.configureFromProjectPreferencesRadioButton = new Button(container, 16400);
        this.configureFromProjectPreferencesRadioButton.setText("Load the following resources to configure ALE's environment");
        this.configureFromProjectPreferencesRadioButton.setToolTipText("ALE source files and Ecore models will be loaded from the paths below");
        this.configureFromProjectPreferencesRadioButton.setSelection(!this.preferences.getBoolean(AleProjectPreferences.CONFIGURED_FROM_DSL_FILE.property(), false));
        this.configureFromProjectPreferencesRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            this.aleSourceFilesPathText.setEnabled(this.configureFromProjectPreferencesRadioButton.getSelection());
            this.ecoreModelsPathText.setEnabled(this.configureFromProjectPreferencesRadioButton.getSelection());
            this.configureFromDslFileRadioButton.setSelection(!this.configureFromProjectPreferencesRadioButton.getSelection());
            this.dslFilePathText.setEnabled(!this.configureFromProjectPreferencesRadioButton.getSelection());
        }));
        GridDataFactory.fillDefaults().span(numColumns, 1).applyTo((Control)this.configureFromProjectPreferencesRadioButton);
        Label label = new Label(container, 0);
        label.setText("ALE source files:");
        label.setToolTipText("Comma-separated list of .ale source files");
        GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).applyTo((Control)label);
        this.aleSourceFilesPathText = new Text(container, 2056);
        this.aleSourceFilesPathText.setText(this.preferences.get(AleProjectPreferences.ALE_SOURCE_FILES.property(), ""));
        this.aleSourceFilesPathText.setLayoutData((Object)new GridData(768));
        this.aleSourceFilesPathText.setEnabled(this.configureFromProjectPreferencesRadioButton.getSelection());
        this.aleSourceFilesPathText.addListener(24, e -> {
            this.configureFromDslFileRadioButton.setSelection(false);
            this.configureFromProjectPreferencesRadioButton.setSelection(true);
            this.aleSourceFilesPathText.setToolTipText(this.aleSourceFilesPathText.getText());
        });
        Button browseAleSourceFiles = new Button(container, 0);
        browseAleSourceFiles.setText("Browse ALE source files...");
        browseAleSourceFiles.setToolTipText("Opens a dialog to select .ale source files");
        GridDataFactory.fillDefaults().applyTo((Control)browseAleSourceFiles);
        browseAleSourceFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ResourceSelectionDialog dialog = new ResourceSelectionDialog(shell, (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "");
                dialog.setTitle("Select the source files defining available behaviors");
                dialog.open();
                Object[] selected = dialog.getResult();
                if (selected == null) {
                    return;
                }
                StringBuilder path = new StringBuilder();
                Object[] objectArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file;
                    Object selection = objectArray[n2];
                    if (selection instanceof IFile && "ale".equals((file = (IFile)selection).getFileExtension())) {
                        if (path.length() > 0) {
                            path.append(",");
                        }
                        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true);
                        path.append(fileURI.toString());
                    }
                    ++n2;
                }
                AleEnvironmentPropertyPage.this.aleSourceFilesPathText.setText(path.toString());
            }
        });
        label = new Label(container, 0);
        label.setText("Ecore models:");
        label.setToolTipText("Comma-separated list of .ecore model files");
        GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).applyTo((Control)label);
        this.ecoreModelsPathText = new Text(container, 2056);
        this.ecoreModelsPathText.setText(this.preferences.get(AleProjectPreferences.ECORE_MODEL_FILES.property(), ""));
        this.ecoreModelsPathText.setLayoutData((Object)new GridData(768));
        this.ecoreModelsPathText.setEnabled(this.configureFromProjectPreferencesRadioButton.getSelection());
        this.ecoreModelsPathText.addListener(24, e -> {
            this.configureFromDslFileRadioButton.setSelection(false);
            this.configureFromProjectPreferencesRadioButton.setSelection(true);
            this.ecoreModelsPathText.setToolTipText(this.ecoreModelsPathText.getText());
        });
        Button browseEcoreModels = new Button(container, 0);
        browseEcoreModels.setText("Browse Ecore model files...");
        browseEcoreModels.setToolTipText("Opens a dialog to select .ecore model files");
        GridDataFactory.fillDefaults().applyTo((Control)browseEcoreModels);
        browseEcoreModels.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ResourceSelectionDialog dialog = new ResourceSelectionDialog(shell, (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "");
            dialog.setTitle("Select the source files defining available behaviors");
            dialog.open();
            Object[] selected = dialog.getResult();
            if (selected == null) {
                return;
            }
            StringBuilder path = new StringBuilder();
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                Object selection = objectArray[n2];
                if (selection instanceof IFile && "ecore".equals((file = (IFile)selection).getFileExtension())) {
                    if (path.length() > 0) {
                        path.append(",");
                    }
                    URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true);
                    path.append(fileURI.toString());
                }
                ++n2;
            }
            this.ecoreModelsPathText.setText(path.toString());
        }));
    }

    private void createConfigureFromDslFileGroup(Composite container) {
        int numColumns = 3;
        this.configureFromDslFileRadioButton = new Button(container, 16400);
        this.configureFromDslFileRadioButton.setText("Load the following DSL configuration file to configure ALE's environment");
        this.configureFromDslFileRadioButton.setToolTipText("ALE source files and Ecore models will be loaded from a .dsl file");
        this.configureFromDslFileRadioButton.setSelection(this.preferences.getBoolean(AleProjectPreferences.CONFIGURED_FROM_DSL_FILE.property(), false));
        this.configureFromDslFileRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            this.configureFromProjectPreferencesRadioButton.setSelection(!this.configureFromDslFileRadioButton.getSelection());
            this.aleSourceFilesPathText.setEnabled(!this.configureFromDslFileRadioButton.getSelection());
            this.ecoreModelsPathText.setEnabled(!this.configureFromDslFileRadioButton.getSelection());
            this.dslFilePathText.setEnabled(this.configureFromDslFileRadioButton.getSelection());
        }));
        GridDataFactory.fillDefaults().span(numColumns, 1).applyTo((Control)this.configureFromDslFileRadioButton);
        Label label = new Label(container, 0);
        label.setText("DSL configuration file:");
        GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).applyTo((Control)label);
        this.dslFilePathText = new Text(container, 2056);
        this.dslFilePathText.setToolTipText("Path to the .dsl configuration file");
        this.dslFilePathText.setLayoutData((Object)new GridData(768));
        this.dslFilePathText.setText(this.preferences.get(AleProjectPreferences.DSL_FILE_PATH.property(), ""));
        this.dslFilePathText.setEnabled(this.configureFromDslFileRadioButton.getSelection());
        this.dslFilePathText.addListener(24, e -> {
            this.configureFromDslFileRadioButton.setSelection(true);
            this.configureFromProjectPreferencesRadioButton.setSelection(false);
        });
        Button browseDslFile = new Button(container, 0);
        browseDslFile.setText("Select DSL file...");
        browseDslFile.setToolTipText("Opens a dialog to select a .dsl file within the workspace");
        browseDslFile.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(shell, false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
            dialog.setTitle("Select a DSL configuration file");
            dialog.setInitialPattern("*.dsl");
            dialog.open();
            Object[] selected = dialog.getResult();
            if (selected != null && selected.length == 1 && selected[0] instanceof IResource) {
                IResource selectedModel = (IResource)selected[0];
                URI dslFileURI = URI.createPlatformResourceURI((String)selectedModel.getFullPath().toPortableString(), (boolean)true);
                this.dslFilePathText.setText(dslFileURI.toString());
            }
        }));
    }

    private static StyledText createLink(Composite parent, String text, String link, int linkStartIndex, int linkLength) {
        StyledText styledText = new StyledText(parent, 64);
        styledText.setText(text);
        styledText.setBackground(parent.getBackground());
        StyleRange style = new StyleRange();
        style.underline = true;
        style.underlineStyle = 4;
        style.start = linkStartIndex;
        style.length = linkLength;
        styledText.setStyleRange(style);
        styledText.addListener(3, event -> {
            int clickOffset = styledText.getCaretOffset();
            if (linkStartIndex <= clickOffset && clickOffset < linkStartIndex + linkLength) {
                Program.launch((String)link);
            }
        });
        styledText.setBottomMargin(5);
        styledText.setToolTipText(link);
        return styledText;
    }
}

