/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig;

import java.io.IOException;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig.AbstractAleLaunchShortcut;

public class DslFileAleLaunchShortcut
extends AbstractAleLaunchShortcut {
    private IAleEnvironment environment;
    private IResource modelFile;
    private String baseConfigurationName;

    @Override
    protected void prepareLaunchOn(IResource resource) throws CoreException {
        if (!(resource instanceof IFile)) {
            throw new IllegalArgumentException("Shortcut can only be applied on .dsl files (got: " + resource + ")");
        }
        IFile dslFile = (IFile)resource;
        try {
            this.environment = new FileBasedAleEnvironment(dslFile.getContents());
            this.baseConfigurationName = this.configurationNameFor((IResource)dslFile);
            this.modelFile = DslFileAleLaunchShortcut.askUserToSelectAnXmiModel((IResource)dslFile).orElse(null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.ecoretools.ale.ide", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    protected String getBaseConfigurationName() {
        return this.baseConfigurationName;
    }

    @Override
    protected IAleEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    protected Optional<IResource> getModel() {
        return Optional.ofNullable(this.modelFile);
    }

    private String configurationNameFor(IResource dslFile) {
        String fileName = dslFile.getName();
        if (!fileName.contains(".")) {
            return fileName;
        }
        String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf("."));
        return fileNameWithoutExtension;
    }
}

