/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.AleInterpreter;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig.MethodRepresentation;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class AleLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Text dslSelection;
    private Text modelSelection;
    private Text mainMethodSelection;
    private Text mainModelElementSelection;
    private AleInterpreter interpreter;

    public void createControl(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        area.setLayout((Layout)gl);
        area.layout();
        this.setControl((Control)area);
        Group dslArea = this.createGroup(area, "Language");
        this.createDslWidgets((Composite)dslArea);
        Group modelArea = this.createGroup(area, "Model");
        this.createModelWidgets((Composite)modelArea);
        Group executionArea = this.createGroup(area, "Execution");
        this.createExecutionWidgets((Composite)executionArea);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("DSL_FILE", "");
        configuration.setAttribute("MODEL_FILE", "");
        configuration.setAttribute("MAIN_METHOD", "");
        configuration.setAttribute("MAIN_MODEL_ELEMENT", "");
        try {
            configuration.doSave();
        }
        catch (CoreException e) {
            Activator.error("Unable to init ALE launch configuration with default values", e);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.dslSelection.setText(configuration.getAttribute("DSL_FILE", ""));
            this.modelSelection.setText(configuration.getAttribute("MODEL_FILE", ""));
            this.mainMethodSelection.setText(configuration.getAttribute("MAIN_METHOD", ""));
            this.mainModelElementSelection.setText(configuration.getAttribute("MAIN_MODEL_ELEMENT", ""));
        }
        catch (CoreException e) {
            Activator.error("Unable to init ALE launch configuration from " + configuration, e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("DSL_FILE", this.dslSelection.getText().trim());
        configuration.setAttribute("MODEL_FILE", this.modelSelection.getText().trim());
        configuration.setAttribute("MAIN_METHOD", this.mainMethodSelection.getText().trim());
        configuration.setAttribute("MAIN_MODEL_ELEMENT", this.mainModelElementSelection.getText().trim());
    }

    public String getName() {
        return "ALE Launch Tab";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String dslName = this.dslSelection.getText().trim();
        String modelName = this.modelSelection.getText().trim();
        if (!dslName.isEmpty() && !modelName.isEmpty()) {
            IResource dslFile = workspace.getRoot().findMember(dslName);
            IResource modelFile = workspace.getRoot().findMember(modelName);
            if (dslFile == null || !dslFile.exists()) {
                return false;
            }
            if (modelFile == null || !modelFile.exists()) {
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridLayout locationLayout = new GridLayout();
        locationLayout.numColumns = 3;
        locationLayout.marginHeight = 10;
        locationLayout.marginWidth = 10;
        group.setLayout((Layout)locationLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        return group;
    }

    private void createModelWidgets(Composite parent) {
        Label modelSelectionLabel = new Label(parent, 0);
        modelSelectionLabel.setText("Model to execute");
        this.modelSelection = new Text(parent, 2052);
        this.modelSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.modelSelection.addModifyListener(modifyEvent -> this.updateLaunchConfigurationDialog());
        Button modelLocationButton = this.createPushButton(parent, "Browse", null);
        modelLocationButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
            dialog.setTitle("Model Selection");
            if (dialog.open() == 0) {
                Object[] selected = dialog.getResult();
                this.modelSelection.setText(((IResource)selected[0]).getFullPath().toPortableString());
            }
        }));
    }

    private void createDslWidgets(Composite parent) {
        Label modelSelectionLabel = new Label(parent, 0);
        modelSelectionLabel.setText("Configuration");
        this.dslSelection = new Text(parent, 2052);
        this.dslSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dslSelection.addModifyListener(modifyEvent -> this.updateLaunchConfigurationDialog());
        Button dslLocationButton = this.createPushButton(parent, "Browse", null);
        dslLocationButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
            dialog.setTitle("DSL Selection");
            if (dialog.open() == 0) {
                Object[] selected = dialog.getResult();
                this.dslSelection.setText(((IResource)selected[0]).getFullPath().toPortableString());
            }
        }));
    }

    private void createExecutionWidgets(Composite parent) {
        Label mainMethodSelectionLabel = new Label(parent, 0);
        mainMethodSelectionLabel.setText("Main method");
        this.mainMethodSelection = new Text(parent, 2052);
        this.mainMethodSelection.setEditable(false);
        this.mainMethodSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mainMethodSelection.addModifyListener(modifyEvent -> this.updateLaunchConfigurationDialog());
        Button mainMethodSelectionButton = this.createPushButton(parent, "Browse", null);
        mainMethodSelectionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            try {
                Optional<Method> selectedMain = AleLaunchConfigurationTab.askUserToSelectMainMethod(shell, this.getAvailableMethods());
                selectedMain.ifPresent(main -> this.mainMethodSelection.setText(new MethodLabelProvider().getText(main)));
            }
            catch (IOException | CoreException e) {
                MessageDialog.openError((Shell)shell, (String)"Unable to find @main methods", (String)("File not found in workspace: " + e.getMessage()));
                Activator.error("Unable to find @main methods", e);
            }
        }));
        Label mainModelElementSelectionLabel = new Label(parent, 0);
        mainModelElementSelectionLabel.setText("Main model element path");
        this.mainModelElementSelection = new Text(parent, 2052);
        this.mainModelElementSelection.setEditable(false);
        this.mainModelElementSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mainModelElementSelection.addModifyListener(modifyEvent -> this.updateLaunchConfigurationDialog());
        Button mainModelElementSelectionButton = this.createPushButton(parent, "Browse", null);
        mainModelElementSelectionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            try {
                IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.modelSelection.getText()));
                if (!resourceFile.exists()) {
                    MessageDialog.openInformation((Shell)parent.getShell(), (String)"Model not selected", (String)"You must select a model first.");
                    return;
                }
                ResourceSetImpl resources = new ResourceSetImpl();
                resources.getResource(URI.createPlatformResourceURI((String)this.modelSelection.getText(), (boolean)true), true);
                Optional<EObject> mainModelElement = AleLaunchConfigurationTab.askUserToChooseMainModelElement(parent.getShell(), (ResourceSet)resources);
                mainModelElement.ifPresent(mainElement -> {
                    String resourceRelativeURI = mainElement.eResource().getURIFragment(mainElement);
                    this.mainModelElementSelection.setText(resourceRelativeURI);
                });
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)parent.getShell(), (String)"Cannot select the model element to execute", (String)"Please check that the model to execute is a valid XMI model. See more details in the Log Error view");
            }
        }));
    }

    private static Optional<EObject> askUserToChooseMainModelElement(Shell shell, ResourceSet resourceSet) {
        ComposedAdapterFactory fatory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        try {
            fatory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            fatory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)fatory), (ITreeContentProvider)new AdapterFactoryContentProvider((AdapterFactory)fatory));
            dialog.setTitle("Select the main model element");
            dialog.setMessage("Select the element on which the @main method will be called:");
            dialog.setAllowMultiple(false);
            dialog.setValidator((ISelectionStatusValidator)new AcceptModelElementsOnly());
            dialog.setInput((Object)resourceSet);
            if (dialog.open() == 0) {
                EObject selection = (EObject)dialog.getFirstResult();
                Optional<EObject> optional = Optional.of(selection);
                return optional;
            }
            Optional<EObject> optional = Optional.empty();
            return optional;
        }
        finally {
            fatory.dispose();
        }
    }

    private final List<Method> getAvailableMethods() throws CoreException, IOException {
        IFile dslFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.dslSelection.getText()));
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileBasedAleEnvironment dsl = IAleEnvironment.fromFile((IFile)dslFile);){
            return dsl.getBehaviors().getMainMethods();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Optional<Method> askUserToSelectMainMethod(Shell shell, List<Method> methods) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new MethodLabelProvider());
        dialog.setElements(methods.toArray());
        dialog.setTitle("Select the @main method to call");
        dialog.setMessage("Select method to use as the program's entry point:");
        if (dialog.open() == 0) {
            Method selection = (Method)dialog.getFirstResult();
            return Optional.of(selection);
        }
        return Optional.empty();
    }

    private static class AcceptModelElementsOnly
    implements ISelectionStatusValidator {
        private AcceptModelElementsOnly() {
        }

        public IStatus validate(Object[] selection) {
            if (selection.length == 0) {
                return Status.CANCEL_STATUS;
            }
            Object selected = selection[0];
            boolean isAModelElementSelected = selected instanceof DynamicEObjectImpl;
            return isAModelElementSelected ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }
    }

    private static class MethodLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private MethodLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            Method method = (Method)element;
            return MethodRepresentation.of(method, null).toString();
        }
    }
}

