/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model.values;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLVariable;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLDebugTarget;
import fr.inria.aoste.timesquare.launcher.debug.model.values.CCSLBooleanValue;
import org.eclipse.debug.core.DebugException;

public final class CCSLBooleanVariable
extends CCSLVariable {
    public CCSLBooleanVariable(ICCSLDebugTarget target, String name) {
        super(target, name, "boolean");
        this.setValue(new CCSLBooleanValue(target, false));
    }

    public boolean verifyValue(String expression) throws DebugException {
        try {
            Integer.parseInt(expression);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private CCSLBooleanValue getBooleanValue() {
        return (CCSLBooleanValue)super.getValue();
    }

    @Override
    public void setValue(String expression) {
        super.setValue(expression);
        this.getBooleanValue().setValue(Boolean.parseBoolean(expression));
    }

    public void setValue(boolean v) {
        super.setValue(String.valueOf(v));
        this.getBooleanValue().setValue(v);
    }
}

