/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import org.eclipse.ajdt.internal.ui.editor.AJFormattingStrategy;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.editor.PointcutElementHyperlinkDetector;
import org.eclipse.ajdt.internal.ui.editor.contentassist.AJCompletionProcessor;
import org.eclipse.ajdt.internal.ui.editor.outline.AJOutlineInformationControl;
import org.eclipse.jdt.internal.ui.text.JavaElementProvider;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class AJSourceViewerConfiguration
extends JavaSourceViewerConfiguration {
    AspectJTextTools ajtt = null;

    public AJSourceViewerConfiguration(AspectJTextTools textTools, AspectJEditor editor) {
        super(textTools.getColorManager(), textTools.getPreferenceStore(), (ITextEditor)editor, "___java_partitioning");
        this.ajtt = textTools;
    }

    protected RuleBasedScanner getCodeScanner() {
        return this.ajtt.getCodeScanner();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IContentAssistant assistant = super.getContentAssistant(sourceViewer);
        if (assistant != null && assistant instanceof ContentAssistant) {
            ContentAssistant cAssi = (ContentAssistant)assistant;
            AJCompletionProcessor ajProcessor = new AJCompletionProcessor((IEditorPart)this.getEditor(), (ContentAssistant)assistant, "__dftl_partition_content_type");
            cAssi.setContentAssistProcessor((IContentAssistProcessor)ajProcessor, "__dftl_partition_content_type");
            this.configureAJProcessor((ContentAssistant)assistant, this.fPreferenceStore, ajProcessor);
        }
        return assistant;
    }

    private void configureAJProcessor(ContentAssistant assistant, IPreferenceStore store, AJCompletionProcessor jcp) {
        String triggers = store.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null) {
            jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean("content_assist_show_visible_proposals");
        jcp.restrictProposalsToVisibility(enabled);
        enabled = store.getBoolean("content_assist_case_sensitivity");
        jcp.restrictProposalsToMatchingCases(enabled);
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.ajtt.getAspectjCodeScanner().affectsBehavior(event) || super.affectsTextPresentation(event);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        IContentFormatter formatter = super.getContentFormatter(sourceViewer);
        if (formatter instanceof MultiPassContentFormatter) {
            ((MultiPassContentFormatter)formatter).setMasterStrategy((IFormattingStrategy)new AJFormattingStrategy());
        }
        return formatter;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new AJOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = doCodeResolve ? new InformationPresenter(this.getOutlinePresenterControlCreator("org.eclipse.jdt.ui.navigate.java.open.structure")) : new InformationPresenter(this.getOutlinePresenterControlCreator("org.eclipse.jdt.ui.edit.text.java.show.outline"));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        JavaElementProvider provider = new JavaElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.getEditor() == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 1];
        detectors[0] = new PointcutElementHyperlinkDetector(this.getEditor());
        int i = 0;
        while (i < inheritedDetectorsLength) {
            detectors[i + 1] = inheritedDetectors[i];
            ++i;
        }
        return detectors;
    }
}

