/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.extensions.sirius.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.executionframework.extensions.sirius.Activator;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.IModelAnimator;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.ParallelStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public abstract class AbstractGemocAnimatorServices {
    public static final GemocModelAnimator ANIMATOR = new GemocModelAnimator();

    public AbstractGemocAnimatorServices() {
        for (StringCouple couple : this.getRepresentationRefreshList()) {
            if (couple.getSecond() != null) {
                ANIMATOR.addRepresentationToRefresh(couple.getFirst(), couple.getSecond());
                continue;
            }
            ANIMATOR.addRepresentationToRefresh(couple.getFirst());
        }
    }

    public static IModelAnimator getAnimator() {
        return ANIMATOR;
    }

    protected abstract List<StringCouple> getRepresentationRefreshList();

    public boolean hasBeenActivated(EObject instruction) {
        boolean res = false;
        URI uri = EcoreUtil.getURI((EObject)instruction);
        for (Set<URI> instructions : AbstractGemocAnimatorServices.ANIMATOR.activatedInstructions.values()) {
            if (!instructions.contains(uri)) continue;
            res = true;
            break;
        }
        return res;
    }

    public static final class GemocModelAnimator
    implements IModelAnimator {
        private static final Set<String> ANY_LAYER = new HashSet<String>();
        private final Map<String, Set<String>> representationToRefresh = new HashMap<String, Set<String>>();
        private final Map<Object, Set<URI>> activatedInstructions = new HashMap<Object, Set<URI>>();
        Executor latestTaskExecutor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), new ThreadPoolExecutor.DiscardOldestPolicy());
        protected long lastSiriusNotification = System.currentTimeMillis();
        public int intervalBetweenSiriusNotification = 1000;
        protected Timer siriusNotificationTimer;

        public void notifySirius(Set<URI> instructionUris) {
            final Map<String, Set<String>> toRefresh = this.representationToRefresh;
            for (final IEditingSession session : SessionUIManager.INSTANCE.getUISessions()) {
                final TransactionalEditingDomain transactionalEditingDomain = session.getSession().getTransactionalEditingDomain();
                ResourceSet resourceSet = transactionalEditingDomain.getResourceSet();
                boolean instructionPresent = this.isOneInstructionPresent(instructionUris, resourceSet);
                if (!instructionPresent) continue;
                long elapsedTimeSinceLastNotif = System.currentTimeMillis() - this.lastSiriusNotification;
                switch (Activator.getDefault().getAnimationRefreshStrategy()) {
                    case Every: {
                        List<DRepresentation> representations = this.getRepresentationsToRefresh(toRefresh, session);
                        this.refreshRepresentations(transactionalEditingDomain, representations);
                        break;
                    }
                    case Manual: {
                        break;
                    }
                    case OnPause: {
                        break;
                    }
                    case CommandQueue: {
                        this.latestTaskExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                List<DRepresentation> representations = this.getRepresentationsToRefresh(toRefresh, session);
                                this.refreshRepresentations(transactionalEditingDomain, representations);
                            }
                        });
                        break;
                    }
                    case Frequencylimit: {
                        if (elapsedTimeSinceLastNotif >= (long)this.intervalBetweenSiriusNotification) {
                            if (this.siriusNotificationTimer != null) {
                                this.siriusNotificationTimer.cancel();
                                this.siriusNotificationTimer = null;
                            }
                            this.lastSiriusNotification = System.currentTimeMillis();
                            this.latestTaskExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    List<DRepresentation> representations = this.getRepresentationsToRefresh(toRefresh, session);
                                    this.refreshRepresentations(transactionalEditingDomain, representations);
                                }
                            });
                            break;
                        }
                        if (this.siriusNotificationTimer != null) break;
                        this.siriusNotificationTimer = new Timer("SiriusNotificationTimer");
                        TimerTask task = new TimerTask(){

                            @Override
                            public void run() {
                                lastSiriusNotification = System.currentTimeMillis();
                                siriusNotificationTimer = null;
                                List<DRepresentation> representations = this.getRepresentationsToRefresh(toRefresh, session);
                                this.refreshRepresentations(transactionalEditingDomain, representations);
                                this.cancel();
                            }
                        };
                        try {
                            this.siriusNotificationTimer.schedule(task, (long)this.intervalBetweenSiriusNotification - elapsedTimeSinceLastNotif);
                            break;
                        }
                        catch (Exception e) {
                            this.siriusNotificationTimer = null;
                        }
                    }
                }
            }
        }

        public void refreshRepresentations(TransactionalEditingDomain transactionalEditingDomain, List<DRepresentation> representations) {
            if (representations.size() != 0) {
                RefreshRepresentationsCommand refresh = new RefreshRepresentationsCommand(transactionalEditingDomain, (IProgressMonitor)new NullProgressMonitor(), representations);
                try {
                    CommandExecution.execute((TransactionalEditingDomain)transactionalEditingDomain, (RecordingCommand)refresh);
                }
                catch (Exception e) {
                    String repString = representations.stream().map(r -> r.getName()).collect(Collectors.joining(", "));
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.gemoc.executionframework.extensions.sirius", "Failed to refresh Sirius representation(s)[" + repString + "], we hope to be able to do it later", (Throwable)e));
                }
            }
        }

        private List<DRepresentation> getRepresentationsToRefresh(Map<String, Set<String>> toRefresh, IEditingSession session) {
            ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>();
            for (DialectEditor editor : session.getEditors()) {
                RepresentationDescription description;
                DRepresentation representation = editor.getRepresentation();
                if (representation == null || (description = DialectManager.INSTANCE.getDescription(representation)) == null) continue;
                String representationId = description.getName();
                Set<String> layerIDs = toRefresh.get(representationId);
                if (layerIDs == ANY_LAYER) {
                    representations.add(representation);
                    continue;
                }
                if (layerIDs == null || !(representation instanceof DDiagram) || !this.isActiveLayer((DDiagram)representation, layerIDs)) continue;
                representations.add(representation);
            }
            return representations;
        }

        private boolean isOneInstructionPresent(Set<URI> instructionUris, ResourceSet resourceSet) {
            boolean instructionPresent = false;
            for (URI instructionUri : instructionUris) {
                if (resourceSet.getEObject(instructionUri, false) == null) continue;
                instructionPresent = true;
                break;
            }
            return instructionPresent;
        }

        private boolean isActiveLayer(DDiagram diagram, Set<String> layerIDs) {
            boolean res = false;
            for (Layer layer : diagram.getActivatedLayers()) {
                if (!layerIDs.contains(layer.getName())) continue;
                res = true;
                break;
            }
            return res;
        }

        public void addRepresentationToRefresh(String representationID) {
            this.representationToRefresh.put(representationID, ANY_LAYER);
        }

        public void addRepresentationToRefresh(String representationID, String layerID) {
            Set<String> layerIDs = this.representationToRefresh.get(representationID);
            if (layerIDs != ANY_LAYER) {
                if (layerIDs == null) {
                    layerIDs = new HashSet<String>();
                    this.representationToRefresh.put(representationID, layerIDs);
                }
                layerIDs.add(layerID);
            }
        }

        @Override
        public void activate(Object context, Step<?> step) {
            HashSet<URI> instructionURIs = new HashSet<URI>();
            MSEOccurrence mseOccurrence = step.getMseoccurrence();
            if (mseOccurrence != null && mseOccurrence.getMse() != null && mseOccurrence.getMse().getCaller() != null) {
                instructionURIs.add(EcoreUtil.getURI((EObject)mseOccurrence.getMse().getCaller()));
            }
            if (step instanceof ParallelStep) {
                for (Step substep : ((ParallelStep)step).getSubSteps()) {
                    if (substep.getMseoccurrence() == null || substep.getMseoccurrence().getMse() == null || substep.getMseoccurrence().getMse().getCaller() == null) continue;
                    instructionURIs.add(EcoreUtil.getURI((EObject)substep.getMseoccurrence().getMse().getCaller()));
                }
            }
            this.clear(context);
            Set<URI> oldInstructions = this.activatedInstructions.get(context);
            if (oldInstructions == null) {
                oldInstructions = new HashSet<URI>();
                this.activatedInstructions.put(context, oldInstructions);
            }
            oldInstructions.addAll(instructionURIs);
            this.notifySirius(instructionURIs);
        }

        @Override
        public void clear(Object context) {
            Set<URI> oldInstructions = this.activatedInstructions.remove(context);
            if (oldInstructions != null && oldInstructions.size() != 0) {
                HashSet<URI> tmpInstructions = new HashSet<URI>(oldInstructions);
                this.notifySirius(tmpInstructions);
            }
        }

        public void engineAboutToStart(IExecutionEngine<?> engine) {
            this.siriusNotificationTimer = null;
        }

        public void engineStarted(IExecutionEngine<?> executionEngine) {
        }

        public void engineAboutToStop(IExecutionEngine<?> engine) {
        }

        public void engineStopped(IExecutionEngine<?> engine) {
            this.siriusNotificationTimer = null;
            this.clear(engine);
        }

        public void engineStatusChanged(IExecutionEngine<?> engine, EngineStatus.RunStatus newStatus) {
        }

        public boolean isRepresentationToRefresh(String representationId, String layerID) {
            Set<String> layerIDs = this.representationToRefresh.get(representationId);
            boolean res = layerIDs == ANY_LAYER || layerIDs != null && layerIDs.contains(layerID);
            return res;
        }

        public void proposedStepsChanged(IExecutionEngine<?> engine, Collection<Step<?>> logicalSteps) {
        }

        public void engineAboutToDispose(IExecutionEngine<?> engine) {
            if (engine.getExecutionContext().getRunConfiguration().getAnimatorURI() != null) {
                Session session = SessionManager.INSTANCE.getSession(engine.getExecutionContext().getRunConfiguration().getAnimatorURI(), (IProgressMonitor)new NullProgressMonitor());
                session.close((IProgressMonitor)new NullProgressMonitor());
                SessionManager.INSTANCE.remove(session);
            }
        }

        public List<String> validate(List<IEngineAddon> otherAddons) {
            return new ArrayList<String>();
        }

        public void aboutToSelectStep(IExecutionEngine<?> engine, Collection<Step<?>> logicalSteps) {
        }

        public void stepSelected(IExecutionEngine<?> engine, Step<?> selectedLogicalStep) {
        }

        public void aboutToExecuteStep(IExecutionEngine<?> engine, Step<?> stepToExecute) {
            if (!(stepToExecute.eContainer() instanceof ParallelStep)) {
                this.activate(engine, stepToExecute);
            }
        }

        public void stepExecuted(IExecutionEngine<?> engine, Step<?> stepExecuted) {
            if (!(stepExecuted.eContainer() instanceof ParallelStep)) {
                this.activate(engine, stepExecuted);
            }
        }
    }

    public static final class StringCouple {
        private final String first;
        private final String second;

        public StringCouple(String first, String second) {
            this.first = first;
            this.second = second;
        }

        public String getFirst() {
            return this.first;
        }

        public String getSecond() {
            return this.second;
        }
    }
}

