/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.InternalRawEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectObservableList
extends ObservableList
implements IObserving,
InternalRawEList {
    protected EObject eObject;
    protected EStructuralFeature eStructuralFeature;
    protected Adapter listener;

    public EObjectObservableList(EObject eObject, EStructuralFeature eStructuralFeature) {
        this(Realm.getDefault(), eObject, eStructuralFeature);
    }

    public EObjectObservableList(Realm realm, EObject eObject, EStructuralFeature eStructuralFeature) {
        super(realm, (List)((EList)eObject.eGet(eStructuralFeature)), (Object)eStructuralFeature);
        this.eObject = eObject;
        this.eStructuralFeature = eStructuralFeature;
    }

    protected void firstListenerAdded() {
        this.listener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (EObjectObservableList.this.eStructuralFeature == notification.getFeature() && !notification.isTouch()) {
                    ListDiff diff;
                    switch (notification.getEventType()) {
                        case 3: {
                            diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)notification.getPosition(), (boolean)true, (Object)notification.getNewValue()));
                            break;
                        }
                        case 5: {
                            Collection newValues = (Collection)notification.getNewValue();
                            ListDiffEntry[] listDiffEntries = new ListDiffEntry[newValues.size()];
                            int position = notification.getPosition();
                            int index = 0;
                            for (Object newValue : newValues) {
                                listDiffEntries[index++] = Diffs.createListDiffEntry((int)position++, (boolean)true, newValue);
                            }
                            diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                            break;
                        }
                        case 4: {
                            diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)notification.getPosition(), (boolean)false, (Object)notification.getOldValue()));
                            break;
                        }
                        case 6: {
                            Collection oldValues = (Collection)notification.getOldValue();
                            ListDiffEntry[] listDiffEntries = new ListDiffEntry[oldValues.size()];
                            int position = notification.getPosition();
                            int index = 0;
                            for (Object oldValue : oldValues) {
                                listDiffEntries[index++] = Diffs.createListDiffEntry((int)position++, (boolean)false, oldValue);
                            }
                            diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                            break;
                        }
                        case 1: 
                        case 9: {
                            ListDiffEntry[] listDiffEntries = new ListDiffEntry[]{Diffs.createListDiffEntry((int)notification.getPosition(), (boolean)false, (Object)notification.getOldValue()), Diffs.createListDiffEntry((int)notification.getPosition(), (boolean)true, (Object)notification.getNewValue())};
                            diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                            break;
                        }
                        case 7: {
                            Object movedValue = notification.getNewValue();
                            ListDiffEntry[] listDiffEntries = new ListDiffEntry[]{Diffs.createListDiffEntry((int)((Integer)notification.getOldValue()), (boolean)false, (Object)movedValue), Diffs.createListDiffEntry((int)notification.getPosition(), (boolean)true, (Object)movedValue)};
                            diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                            break;
                        }
                        case 2: {
                            return;
                        }
                        default: {
                            throw new RuntimeException("unhandled case");
                        }
                    }
                    EObjectObservableList.this.getRealm().exec(new Runnable(){

                        public void run() {
                            EObjectObservableList.this.fireListChange(diff);
                        }
                    });
                }
            }
        };
        this.eObject.eAdapters().add((Object)this.listener);
    }

    protected void lastListenerRemoved() {
        this.eObject.eAdapters().remove((Object)this.listener);
        this.listener = null;
    }

    public synchronized void dispose() {
        if (this.listener != null) {
            this.eObject.eAdapters().remove((Object)this.listener);
            this.listener = null;
        }
        this.eObject = null;
        this.eStructuralFeature = null;
        super.dispose();
    }

    protected final List<Object> wrappedList() {
        return this.wrappedList;
    }

    public Object getObserved() {
        return this.eObject;
    }

    public boolean add(Object object) {
        this.checkRealm();
        return this.wrappedList().add(object);
    }

    public void add(int index, Object object) {
        this.checkRealm();
        this.wrappedList().add(index, object);
    }

    public boolean addAll(Collection collection) {
        this.checkRealm();
        return this.wrappedList().addAll(collection);
    }

    public boolean addAll(int index, Collection collection) {
        this.checkRealm();
        return this.wrappedList().addAll(index, collection);
    }

    public Object set(int index, Object element) {
        this.checkRealm();
        return this.wrappedList().set(index, element);
    }

    public Object remove(int index) {
        this.checkRealm();
        return this.wrappedList.remove(index);
    }

    public boolean remove(Object element) {
        this.checkRealm();
        return this.wrappedList.remove(element);
    }

    public boolean removeAll(Collection collection) {
        this.checkRealm();
        return this.wrappedList().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        this.checkRealm();
        return this.wrappedList().retainAll(collection);
    }

    public void clear() {
        this.checkRealm();
        this.wrappedList.clear();
    }

    public Object move(int oldIndex, int newIndex) {
        this.checkRealm();
        return ((EList)this.wrappedList).move(newIndex, oldIndex);
    }

    public void move(int newPosition, Object object) {
        this.move(this.indexOf(object), newPosition);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getName());
        result.append('@');
        result.append(Integer.toHexString(this.hashCode()));
        result.append(" (eObject:");
        result.append(this.eObject);
        result.append(")");
        result.append(" (eStructuralFeature: ");
        result.append(this.eStructuralFeature);
        result.append(")");
        result.append(" (wrappedList: ");
        result.append(this.wrappedList);
        result.append(")");
        return result.toString();
    }
}

