/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.ale.core.env.ClosedAleEnvironmentException;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.ImmutableBehaviors;
import org.eclipse.emf.ecoretools.ale.core.interpreter.IServiceCallListener;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.AleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.EvalBodyService;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.gemoc.ale.interpreted.engine.Helper;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.executionframework.engine.commons.DefaultExecutionPlatform;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;
import org.eclipse.gemoc.executionframework.engine.commons.GenericModelExecutionContext;
import org.eclipse.gemoc.executionframework.engine.commons.sequential.SequentialRunConfiguration;
import org.eclipse.gemoc.executionframework.engine.core.AbstractSequentialExecutionEngine;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.IModelAnimator;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewListener;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.sirius.common.tools.api.interpreter.IEvaluationResult;

public class AleEngine
extends AbstractSequentialExecutionEngine<GenericModelExecutionContext<SequentialRunConfiguration>, SequentialRunConfiguration> {
    EObject caller;
    ImmutableBehaviors parsedSemantics;
    List<Object> args;
    AleInterpreter interpreter;
    private String mainOp;
    private String initOp;

    public String engineKindName() {
        return "ALE Engine";
    }

    protected void executeEntryPoint() {
        if (this.interpreter != null && this.parsedSemantics != null) {
            this.interpreter.addServiceListener(new IServiceCallListener(){

                public void preCall(IService service, Object[] arguments) {
                    boolean isStep;
                    if (service instanceof EvalBodyService && (isStep = ((EvalBodyService)service).getImplem().getTags().contains((Object)"step")) && arguments[0] instanceof EObject) {
                        EObject currentCaller = (EObject)arguments[0];
                        String className = currentCaller.eClass().getName();
                        String methodName = service.getName();
                        AleEngine.this.beforeExecutionStep(currentCaller, className, methodName);
                    }
                }

                public void postCall(IService service, Object[] arguments, Object result) {
                    boolean isStep;
                    if (service instanceof EvalBodyService && (isStep = ((EvalBodyService)service).getImplem().getTags().contains((Object)"step"))) {
                        AleEngine.this.afterExecutionStep();
                    }
                }
            });
            IMultiDimensionalTraceAddon traceCandidate = null;
            final ArrayList<IModelAnimator> animators = new ArrayList<IModelAnimator>();
            for (IEngineAddon addon : ((DefaultExecutionPlatform)((GenericModelExecutionContext)this.getExecutionContext()).getExecutionPlatform()).getEngineAddons()) {
                if (addon instanceof IMultiDimensionalTraceAddon) {
                    traceCandidate = (IMultiDimensionalTraceAddon)addon;
                    continue;
                }
                if (!(addon instanceof IModelAnimator)) continue;
                animators.add((IModelAnimator)addon);
            }
            final IMultiDimensionalTraceAddon traceAddon = traceCandidate;
            ITraceViewListener diagramUpdater = new ITraceViewListener(){

                public void update() {
                    for (IModelAnimator addon : animators) {
                        try {
                            if (traceAddon == null) continue;
                            Step nextStep = (Step)traceAddon.getTraceExplorer().getCurrentState().getStartedSteps().get(0);
                            addon.activate((Object)AleEngine.this.caller, nextStep);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            if (traceAddon != null) {
                traceAddon.getTraceExplorer().registerCommand(diagramUpdater, () -> diagramUpdater.update());
            }
            Method entryPoint = this.getMainOp().orElse(null);
            if (this.interpreter.getCurrentEngine() != null) {
                EvaluationResult res = this.interpreter.getCurrentEngine().eval(this.caller, entryPoint, Arrays.asList(new Object[0]));
                this.interpreter.getLogger().diagnosticForHuman();
                if (res.getDiagnostic().getMessage() != null) {
                    System.out.println(res.getDiagnostic().getMessage());
                    throw new RuntimeException(res.getDiagnostic().getMessage());
                }
            } else {
                try {
                    IEvaluationResult res = this.interpreter.eval(this.caller, entryPoint, Arrays.asList(new Object[0]));
                    this.interpreter.getLogger().diagnosticForHuman();
                    if (res.getDiagnostic().getMessage() != null) {
                        System.out.println(res.getDiagnostic().getMessage());
                        throw new RuntimeException(res.getDiagnostic().getMessage());
                    }
                }
                catch (ClosedAleEnvironmentException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            if (traceAddon != null) {
                traceAddon.getTraceExplorer().removeListener(diagramUpdater);
            }
        }
    }

    protected void initializeModel() {
        Optional<Method> init = this.getInitOp();
        if (this.interpreter != null && this.parsedSemantics != null && init.isPresent()) {
            try {
                IEvaluationResult res = this.interpreter.eval(this.caller, init.get(), this.args);
                if (res.getDiagnostic().getMessage() != null) {
                    System.out.println(res.getDiagnostic().getMessage());
                    this.interpreter.getLogger().notify(res.getDiagnostic());
                    this.interpreter.getLogger().diagnosticForHuman();
                    throw new RuntimeException(res.getDiagnostic().getMessage());
                }
                this.interpreter.getLogger().diagnosticForHuman();
            }
            catch (ClosedAleEnvironmentException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    protected void prepareEntryPoint(GenericModelExecutionContext<SequentialRunConfiguration> executionContext) {
    }

    protected void prepareInitializeModel(GenericModelExecutionContext<SequentialRunConfiguration> executionContext) {
        if (executionContext.getRunConfiguration() instanceof SequentialRunConfiguration) {
            SequentialRunConfiguration runConf = (SequentialRunConfiguration)executionContext.getRunConfiguration();
            Resource inputModel = executionContext.getResourceModel();
            String rootPath = runConf.getModelEntryPoint();
            this.caller = inputModel.getEObject(rootPath);
            Dsl language = DslHelper.load((String)runConf.getLanguageName());
            this.args = Lists.newArrayList((Object[])runConf.getModelInitializationArguments().split("\n"));
            this.mainOp = runConf.getExecutionEntryPoint();
            this.initOp = runConf.getModelInitializationMethod();
            IAleEnvironment environment = Helper.gemocDslToAleDsl(language);
            this.interpreter = new AleInterpreter(environment, environment.getContext(), true);
            this.parsedSemantics = new ImmutableBehaviors((Collection)environment.getBehaviors().getParsedFiles());
            HashSet projects = new HashSet();
            HashSet<String> plugins = new HashSet<String>();
            if (language.eResource().getURI().isPlatformPlugin()) {
                URI dslUri = language.eResource().getURI();
                String dslPlugin = (String)dslUri.segmentsList().get(1);
                plugins.add(dslPlugin);
                List<String> ecoreUris = Helper.getEcoreUris(language);
                for (String ecoreURI : ecoreUris) {
                    URI uri = URI.createURI((String)ecoreURI);
                    String plugin = (String)uri.segmentsList().get(1);
                    plugins.add(plugin);
                }
                List<String> aleUris = Helper.getAleUris(language);
                for (String aleURI : aleUris) {
                    URI uri = URI.createURI((String)aleURI);
                    String plugin = (String)uri.segmentsList().get(1);
                    plugins.add(plugin);
                }
            }
            this.interpreter.initScope(plugins, projects);
        }
    }

    public List<ModelUnit> getModelUnits() {
        if (this.parsedSemantics != null) {
            return this.parsedSemantics.getParsedFiles().stream().map(p -> (ModelUnit)p.getRoot()).filter(elem -> elem != null).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public AleInterpreter getInterpreter() {
        return this.interpreter;
    }

    public Optional<Method> getMainOp() {
        ArrayList segments;
        if (this.mainOp != null && (segments = Lists.newArrayList((Object[])this.mainOp.split("::"))).size() >= 2) {
            String opName = (String)segments.get(segments.size() - 1);
            String typeName = (String)segments.get(segments.size() - 2);
            return this.getModelUnits().stream().flatMap(unit -> unit.getClassExtensions().stream()).filter(xtdCls -> xtdCls.getBaseClass().getName().equals(typeName)).flatMap(cls -> cls.getMethods().stream()).filter(op -> op.getTags().contains((Object)"main")).filter(op -> op.getOperationRef().getName().equals(opName)).findFirst();
        }
        return Optional.empty();
    }

    public Optional<Method> getInitOp() {
        ArrayList segments;
        if (this.initOp != null && (segments = Lists.newArrayList((Object[])this.initOp.split("::"))).size() >= 2) {
            String opName = (String)segments.get(segments.size() - 1);
            String typeName = (String)segments.get(segments.size() - 2);
            return this.getModelUnits().stream().flatMap(unit -> unit.getClassExtensions().stream()).filter(xtdCls -> xtdCls.getBaseClass().getName().equals(typeName)).flatMap(cls -> cls.getMethods().stream()).filter(op -> op.getTags().contains((Object)"init")).filter(op -> op.getOperationRef().getName().equals(opName)).findFirst();
        }
        return Optional.empty();
    }

    protected void finishDispose() {
        super.finishDispose();
        this.interpreter.close();
    }
}

