/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public class ReplaceFileContentChange
extends ResourceChange {
    private static final Logger LOG = Logger.getLogger(ReplaceFileContentChange.class);
    private final IFile file;
    private final byte[] newContents;
    private String name;

    public ReplaceFileContentChange(String name, IFile file, byte[] newContents) {
        this(file, newContents);
        this.name = name;
    }

    public ReplaceFileContentChange(IFile file, byte[] newContents) {
        this.file = file;
        this.newContents = newContents;
    }

    protected IResource getModifiedResource() {
        return this.file;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (!this.file.exists()) {
            result.addFatalError("File " + this.file.getFullPath() + " does not exist");
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        byte[] oldContents = this.getOldContents();
        ReplaceFileContentChange change = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream newContentsIS = new ByteArrayInputStream(this.newContents);){
                this.file.setContents((InputStream)newContentsIS, true, true, pm);
                change = new ReplaceFileContentChange(this.file, oldContents);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error closing stream", (Throwable)e);
        }
        return change;
    }

    protected byte[] getOldContents() {
        byte[] oldContents = new byte[]{};
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStream oldContentsIS = this.file.getContents();){
                try {
                    oldContents = ByteStreams.toByteArray((InputStream)oldContentsIS);
                }
                catch (IOException e) {
                    LOG.error((Object)("Error reading contents of file " + this.file.getName()), (Throwable)e);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error closing stream", (Throwable)e);
        }
        catch (CoreException e) {
            LOG.error((Object)("Error reading contents of file " + this.file.getName()), (Throwable)e);
        }
        return oldContents;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

