/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.addon.eaop.server;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.eclipse.gemoc.protocols.eaop.api.data.GetStateArguments;
import org.eclipse.gemoc.protocols.eaop.api.data.GetStateResponse;
import org.eclipse.gemoc.protocols.eaop.api.data.GetStepArguments;
import org.eclipse.gemoc.protocols.eaop.api.data.GetStepResponse;
import org.eclipse.gemoc.protocols.eaop.api.data.InitializeArguments;
import org.eclipse.gemoc.protocols.eaop.api.data.InitializeResponse;
import org.eclipse.gemoc.protocols.eaop.api.services.IEngineAddonProtocolClient;
import org.eclipse.gemoc.protocols.eaop.api.services.IEngineAddonProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EaopServerImpl
implements IEngineAddonProtocolServer,
Endpoint,
JsonRpcMethodProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EaopServerImpl.class);
    protected String engineIdRegExp = ".*";
    protected IEngineAddonProtocolClient eaopClient;
    private Map<String, JsonRpcMethod> supportedMethods;

    public void connectClient(IEngineAddonProtocolClient client) {
        this.eaopClient = client;
    }

    public CompletableFuture<?> request(String method, Object parameter) {
        throw new UnsupportedOperationException("The json request '" + method + "' is unknown.");
    }

    public void notify(String method, Object parameter) {
        LOG.debug("notify " + method);
    }

    public Map<String, JsonRpcMethod> supportedMethods() {
        if (this.supportedMethods != null) {
            return this.supportedMethods;
        }
        LinkedHashMap<String, JsonRpcMethod> supportedMethods = new LinkedHashMap<String, JsonRpcMethod>();
        supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(this.getClass()));
        for (JsonRpcMethod supportedMethod : supportedMethods.values()) {
            LOG.info("supported method " + supportedMethod.getMethodName() + " " + supportedMethod.getParameterTypes());
        }
        this.supportedMethods = supportedMethods;
        return supportedMethods;
    }

    public CompletableFuture<InitializeResponse> initialize(InitializeArguments arguments) {
        LOG.info("CompletableFuture<InitializeResponse> initialize()");
        this.engineIdRegExp = ".*";
        CompletableFuture<InitializeResponse> future = CompletableFuture.supplyAsync(new Supplier<InitializeResponse>(){

            @Override
            public InitializeResponse get() {
                InitializeResponse response = new InitializeResponse();
                return response;
            }
        });
        return future;
    }

    public CompletableFuture<GetStateResponse> getState(GetStateArguments arguments) {
        return super.getState(arguments);
    }

    public CompletableFuture<GetStepResponse> getStep(GetStepArguments arguments) {
        return super.getStep(arguments);
    }
}

