/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEBaseVisitor;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEParser;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.parser.internal.AntlrAstToAleBehaviorsFactory;
import org.eclipse.emf.ecoretools.ale.implementation.Assignment;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExpressionStatement;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationFactory;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class AstVisitors {
    private AstVisitors() {
    }

    public static boolean isQualified(String name) {
        return name.contains(".");
    }

    public static String aliasToRealName(String qname, Map<String, String> importedBehaviors) {
        if (AstVisitors.isQualified(qname)) {
            CharSequence[] segments = qname.split("\\.");
            String importSeg = importedBehaviors.get(segments[0]);
            if (importSeg != null) {
                segments[0] = importSeg;
            }
            return String.join((CharSequence)".", segments);
        }
        return qname;
    }

    public static ParsedFile<ModelUnit> visit(ALEParser.RRootContext rootCtx) {
        ParsedFile<ModelUnit> result = new ParsedFile<ModelUnit>();
        result.setDiagnostic((Diagnostic)new BasicDiagnostic());
        ModelUnit root = (ModelUnit)new ModelUnitVisitor(result).visit((ParseTree)rootCtx);
        result.setRoot(root);
        return result;
    }

    public static List<EClass> preVisit(ALEParser.RRootContext ctx) {
        return ctx.rClass().stream().map(c -> c.rNewClass()).filter(c -> c != null).map(cls -> {
            EClass eClsClass = EcorePackage.eINSTANCE.getEClass();
            EClass res = (EClass)EcoreUtil.create((EClass)eClsClass);
            res.setName(cls.name.getText());
            return res;
        }).collect(Collectors.toList());
    }

    static class AttributeVisitor
    extends ALEBaseVisitor<Attribute> {
        ParsedFile<ModelUnit> parseRes;
        EClass fragment;

        public AttributeVisitor(ParsedFile<ModelUnit> parseRes, EClass fragment) {
            this.parseRes = parseRes;
            this.fragment = fragment;
        }

        @Override
        public Attribute visitRAttribute(ALEParser.RAttributeContext ctx) {
            ALEParser.RExpressionContext initialValue = ctx.rExpression();
            ALEParser.RTypeContext type = ctx.type;
            String name = ctx.Ident().getText();
            boolean isUnique = false;
            boolean isContainment = false;
            if (ctx.modifier != null) {
                if (ctx.modifier.getText().equals("contains")) {
                    isContainment = true;
                    isUnique = true;
                } else if (ctx.modifier.getText().equals("unique")) {
                    isUnique = true;
                }
            }
            int lowerBound = 0;
            int upperBound = 1;
            if (ctx.bounds != null) {
                lowerBound = Integer.decode(ctx.bounds.Integer().get(0).getText());
                if (ctx.bounds.Integer().size() > 1) {
                    upperBound = Integer.decode(ctx.bounds.Integer().get(1).getText());
                } else if (ctx.bounds.MultOp() != null && ctx.bounds.MultOp().getText().equals("*")) {
                    upperBound = -1;
                }
            }
            String opposite = null;
            if (ctx.opposite != null) {
                opposite = ctx.opposite.Ident().getText();
            }
            Attribute res = AntlrAstToAleBehaviorsFactory.singleton.buildAttribute(this.fragment, name, initialValue, type, lowerBound, upperBound, isContainment, isUnique, opposite, this.parseRes);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }
    }

    public static class BlockVisitor
    extends ALEBaseVisitor<Block> {
        ParsedFile<ModelUnit> parseRes;

        public BlockVisitor(ParsedFile<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public Block visitRBlock(ALEParser.RBlockContext ctx) {
            StatementVisitor subVisitor = new StatementVisitor(this.parseRes);
            List<Statement> body = ctx.rStatement().stream().map(arg_0 -> ((StatementVisitor)subVisitor).visit(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            Block res = AntlrAstToAleBehaviorsFactory.singleton.buildBlock(body);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }
    }

    static class ModelUnitVisitor
    extends ALEBaseVisitor<ModelUnit> {
        ParsedFile<ModelUnit> parseRes;

        public ModelUnitVisitor(ParsedFile<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public ModelUnit visitRRoot(ALEParser.RRootContext ctx) {
            ImplementationFactory factory = (ImplementationFactory)ImplementationPackage.eINSTANCE.getEFactoryInstance();
            ModelUnit res = factory.createModelUnit();
            res.setName(ctx.rQualified().getText());
            HashMap<String, String> importedBehaviors = new HashMap<String, String>();
            ctx.rImport().stream().forEach(imp -> {
                String string = importedBehaviors.put(imp.Ident().getText(), imp.rQualified().getText());
            });
            OpenClassVisitor subVisitor1 = new OpenClassVisitor(this.parseRes, importedBehaviors);
            res.getClassExtensions().addAll((Collection)ctx.rClass().stream().map(c -> c.rOpenClass()).filter(c -> c != null).map(cls -> (ExtendedClass)subVisitor1.visit((ParseTree)cls)).collect(Collectors.toList()));
            NewClassVisitor subVisitor2 = new NewClassVisitor(this.parseRes);
            res.getClassDefinitions().addAll((Collection)ctx.rClass().stream().map(c -> c.rNewClass()).filter(c -> c != null).map(cls -> (RuntimeClass)subVisitor2.visit((ParseTree)cls)).collect(Collectors.toList()));
            ServiceVisitor serviceVisitor = new ServiceVisitor();
            res.getServices().addAll((Collection)ctx.rService().stream().map(srv -> (String)serviceVisitor.visit((ParseTree)srv)).collect(Collectors.toList()));
            if (this.parseRes.getRoot() != null) {
                this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
                this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
                List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
                this.parseRes.setLines(res, lines);
            }
            return res;
        }
    }

    static class NewClassVisitor
    extends ALEBaseVisitor<RuntimeClass> {
        ParsedFile<ModelUnit> parseRes;

        public NewClassVisitor(ParsedFile<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public RuntimeClass visitRNewClass(ALEParser.RNewClassContext ctx) {
            String name = ctx.name.getText();
            EClass fragment = AntlrAstToAleBehaviorsFactory.singleton.buildEClass(name);
            AttributeVisitor subVisitor1 = new AttributeVisitor(this.parseRes, fragment);
            List<Attribute> attributes = ctx.rAttribute().stream().map(subVisitor1::visitRAttribute).collect(Collectors.toList());
            OpVisitor subVisitor2 = new OpVisitor(this.parseRes, fragment);
            List<Method> operations = ctx.rOperation().stream().map(arg_0 -> ((OpVisitor)subVisitor2).visit(arg_0)).filter(Method.class::isInstance).map(Method.class::cast).collect(Collectors.toList());
            RuntimeClass res = AntlrAstToAleBehaviorsFactory.singleton.buildRuntimeClass(name, attributes, operations);
            res.setFragment(fragment);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }

    static class OpVisitor
    extends ALEBaseVisitor<Method> {
        ParsedFile<ModelUnit> parseRes;
        EClass fragment;

        public OpVisitor(ParsedFile<ModelUnit> parseRes, EClass fragment) {
            this.parseRes = parseRes;
            this.fragment = fragment;
        }

        @Override
        public Method visitROperation(ALEParser.ROperationContext ctx) {
            String keyword = ctx.children.stream().filter(TerminalNode.class::isInstance).findFirst().orElseThrow(() -> new RuntimeException("cannot find any TerminalNode in " + rOperationContext.children)).getText();
            ALEParser.RTypeContext returnType = ctx.type;
            String operationName = ctx.name.getText();
            ArrayList<AntlrAstToAleBehaviorsFactory.Parameter> parameters = new ArrayList();
            if (ctx.rParameters() != null) {
                parameters = (List)new ParamVisitor(this.parseRes).visit((ParseTree)ctx.rParameters());
            }
            Block body = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock());
            String className = ctx.parent.getChild(1).getText();
            RuleContext parent = ctx.parent;
            if (parent instanceof ALEParser.RNewClassContext) {
                className = ((ALEParser.RNewClassContext)parent).name.getText();
            } else if (parent instanceof ALEParser.ROpenClassContext) {
                className = ((ALEParser.ROpenClassContext)parent).name.getText();
            }
            List<String> tags = ctx.rTag().stream().map(t -> t.Ident().getText()).collect(Collectors.toList());
            Method res = null;
            res = keyword.equals("def") ? AntlrAstToAleBehaviorsFactory.singleton.buildMethod(this.fragment, operationName, parameters, returnType, body, tags) : (keyword.equals("override") ? AntlrAstToAleBehaviorsFactory.singleton.buildImplementation(className, operationName, parameters, returnType, body, tags) : AntlrAstToAleBehaviorsFactory.singleton.buildMethod(this.fragment, operationName, parameters, returnType, body, tags));
            if (res.getOperationRef() != null) {
                for (EParameter parameter : res.getOperationRef().getEParameters()) {
                    for (AntlrAstToAleBehaviorsFactory.Parameter raw : parameters) {
                        if (!raw.getName().equals(parameter.getName())) continue;
                        this.parseRes.getStartPositions().put(parameter, raw.getCtx().start.getStartIndex());
                        this.parseRes.getEndPositions().put(parameter, raw.getCtx().stop.getStopIndex());
                        List<Integer> lines = IntStream.rangeClosed(raw.getCtx().start.getLine(), raw.getCtx().stop.getLine()).boxed().collect(Collectors.toList());
                        this.parseRes.setLines(parameter, lines);
                    }
                }
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }
    }

    static class OpenClassVisitor
    extends ALEBaseVisitor<ExtendedClass> {
        ParsedFile<ModelUnit> parseRes;
        Map<String, String> importedBehaviors;

        public OpenClassVisitor(ParsedFile<ModelUnit> parseRes, Map<String, String> importedBehaviors) {
            this.parseRes = parseRes;
            this.importedBehaviors = importedBehaviors;
        }

        @Override
        public ExtendedClass visitROpenClass(ALEParser.ROpenClassContext ctx) {
            String name = ctx.name.getText();
            EClass fragment = null;
            if (!ctx.rAttribute().isEmpty() || !ctx.rOperation().isEmpty()) {
                fragment = AntlrAstToAleBehaviorsFactory.singleton.buildEClass(name);
            }
            AttributeVisitor subVisitor1 = new AttributeVisitor(this.parseRes, fragment);
            List<Attribute> attributes = ctx.rAttribute().stream().map(attr -> subVisitor1.visitRAttribute((ALEParser.RAttributeContext)((Object)attr))).collect(Collectors.toList());
            OpVisitor subVisitor2 = new OpVisitor(this.parseRes, fragment);
            List<Method> operations = ctx.rOperation().stream().map(op -> (Method)subVisitor2.visit((ParseTree)op)).filter(elem -> elem != null).collect(Collectors.toList());
            List<String> extended = ctx.rQualified().stream().skip(1L).map(q -> AstVisitors.aliasToRealName(q.getText(), this.importedBehaviors)).collect(Collectors.toList());
            ExtendedClass res = AntlrAstToAleBehaviorsFactory.singleton.buildExtendedClass(name, attributes, operations, extended);
            res.setFragment(fragment);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }
    }

    static class ParamVisitor
    extends ALEBaseVisitor<List<AntlrAstToAleBehaviorsFactory.Parameter>> {
        ParsedFile<ModelUnit> parseRes;

        public ParamVisitor(ParsedFile<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public List<AntlrAstToAleBehaviorsFactory.Parameter> visitRParameters(ALEParser.RParametersContext ctx) {
            VarVisitor subVisitor = new VarVisitor(this.parseRes);
            List<AntlrAstToAleBehaviorsFactory.Parameter> res = ctx.rVariable().stream().map(arg_0 -> ((VarVisitor)subVisitor).visit(arg_0)).collect(Collectors.toList());
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }
    }

    static class ServiceVisitor
    extends ALEBaseVisitor<String> {
        ServiceVisitor() {
        }

        @Override
        public String visitRService(ALEParser.RServiceContext ctx) {
            String rawText = ctx.getText();
            rawText = rawText.replaceFirst("use", "");
            rawText = rawText.replaceFirst(";", "");
            return rawText.replaceAll("\\t\\r\\n", "");
        }
    }

    static class StatementVisitor
    extends ALEBaseVisitor<Statement> {
        ParsedFile<ModelUnit> parseRes;

        public StatementVisitor(ParsedFile<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        public Statement visitErrorNode(ErrorNode node) {
            return null;
        }

        @Override
        public Statement visitRVarDecl(ALEParser.RVarDeclContext ctx) {
            ALEParser.RTypeContext typeName = ctx.type;
            String name = ctx.Ident().getText();
            ALEParser.RExpressionContext initialValue = ctx.rExpression();
            VariableDeclaration res = AntlrAstToAleBehaviorsFactory.singleton.buildVariableDecl(name, initialValue, typeName, this.parseRes);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }

        @Override
        public Statement visitRAssign(ALEParser.RAssignContext ctx) {
            ALEParser.ExpressionContext left = ctx.expression();
            ALEParser.RExpressionContext value = ctx.rExpression();
            Assignment res = null;
            if (left instanceof ALEParser.VarRefContext) {
                ALEParser.VarRefContext varRef = (ALEParser.VarRefContext)left;
                res = AntlrAstToAleBehaviorsFactory.singleton.buildVariableAssignement(varRef.Ident().getText(), value, this.parseRes);
            } else if (left instanceof ALEParser.NavContext) {
                ALEParser.NavContext navCtx = (ALEParser.NavContext)left;
                ALEParser.NavigationSegmentContext navSegment = navCtx.navigationSegment();
                if (navSegment instanceof ALEParser.FeatureContext) {
                    ALEParser.FeatureContext featCtx = (ALEParser.FeatureContext)navSegment;
                    String feature = featCtx.Ident().getText();
                    ALEParser.ExpressionContext target = navCtx.expression();
                    res = AntlrAstToAleBehaviorsFactory.singleton.buildFeatureAssign(target, feature, value, this.parseRes);
                }
            } else {
                res = AntlrAstToAleBehaviorsFactory.singleton.buildVariableAssignement(left.getText(), value, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }

        @Override
        public Statement visitRInsert(ALEParser.RInsertContext ctx) {
            ALEParser.ExpressionContext left = ctx.expression();
            ALEParser.RExpressionContext value = ctx.rExpression();
            Assignment res = null;
            if (left instanceof ALEParser.NavContext) {
                ALEParser.NavContext navCtx = (ALEParser.NavContext)left;
                ALEParser.NavigationSegmentContext navSegment = navCtx.navigationSegment();
                if (navSegment instanceof ALEParser.FeatureContext) {
                    ALEParser.FeatureContext featCtx = (ALEParser.FeatureContext)navSegment;
                    String feature = featCtx.Ident().getText();
                    ALEParser.ExpressionContext target = navCtx.expression();
                    res = AntlrAstToAleBehaviorsFactory.singleton.buildFeatureInsert(target, feature, value.expression(), this.parseRes);
                }
            } else if (left instanceof ALEParser.VarRefContext) {
                ALEParser.VarRefContext varRef = (ALEParser.VarRefContext)left;
                res = AntlrAstToAleBehaviorsFactory.singleton.buildVariableInsert(varRef.Ident().getText(), value, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }

        @Override
        public Statement visitRRemove(ALEParser.RRemoveContext ctx) {
            ALEParser.ExpressionContext left = ctx.expression();
            ALEParser.RExpressionContext value = ctx.rExpression();
            Assignment res = null;
            if (left instanceof ALEParser.NavContext) {
                ALEParser.NavContext navCtx = (ALEParser.NavContext)left;
                ALEParser.NavigationSegmentContext navSegment = navCtx.navigationSegment();
                if (navSegment instanceof ALEParser.FeatureContext) {
                    ALEParser.FeatureContext featCtx = (ALEParser.FeatureContext)navSegment;
                    String feature = featCtx.Ident().getText();
                    ALEParser.ExpressionContext target = navCtx.expression();
                    res = AntlrAstToAleBehaviorsFactory.singleton.buildFeatureRemove(target, feature, value.expression(), this.parseRes);
                }
            } else if (left instanceof ALEParser.VarRefContext) {
                ALEParser.VarRefContext varRef = (ALEParser.VarRefContext)left;
                res = AntlrAstToAleBehaviorsFactory.singleton.buildVariableRemove(varRef.Ident().getText(), value, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }

        @Override
        public Statement visitRIf(ALEParser.RIfContext ctx) {
            ALEParser.RExpressionContext cond = ctx.rExpression();
            Block then = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock().get(0));
            ConditionalBlock cBlock = AntlrAstToAleBehaviorsFactory.singleton.buildConditionalBlock(cond, then, this.parseRes);
            this.parseRes.getStartPositions().put(cBlock, cond.start.getStartIndex());
            this.parseRes.getEndPositions().put(cBlock, cond.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(cond.start.getLine(), cond.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(cBlock, lines);
            If res = null;
            if (ctx.nestedIf != null) {
                res = (If)this.visitRIf(ctx.nestedIf);
                res.getBlocks().add(0, (Object)cBlock);
            } else {
                Block elseB = null;
                if (ctx.rBlock().size() > 1) {
                    elseB = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock().get(1));
                }
                res = AntlrAstToAleBehaviorsFactory.singleton.buildIf(Arrays.asList(cBlock), elseB, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }

        @Override
        public Statement visitRForEach(ALEParser.RForEachContext ctx) {
            ForEach res = null;
            Block body = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock());
            ALEParser.RExpressionContext collectionExp = ctx.rCollection().rExpression();
            if (collectionExp == null) {
                String left = ctx.rCollection().Integer().get(0).getText();
                String right = ctx.rCollection().Integer().get(1).getText();
                SequenceInExtensionLiteral intSeq = AntlrAstToAleBehaviorsFactory.singleton.buildIntSequence(left, right);
                res = AntlrAstToAleBehaviorsFactory.singleton.buildForEach(ctx.Ident().getText(), intSeq, body);
            } else {
                res = AntlrAstToAleBehaviorsFactory.singleton.buildForEach(ctx.Ident().getText(), collectionExp, body, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }

        @Override
        public Statement visitRWhile(ALEParser.RWhileContext ctx) {
            Block body = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock());
            While res = AntlrAstToAleBehaviorsFactory.singleton.buildWhile(ctx.rExpression(), body, this.parseRes);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }

        @Override
        public Statement visitRExpressionStmt(ALEParser.RExpressionStmtContext ctx) {
            ExpressionStatement res = AntlrAstToAleBehaviorsFactory.singleton.buildExpressionStatement(ctx.rExpression(), this.parseRes);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }

    static class VarVisitor
    extends ALEBaseVisitor<AntlrAstToAleBehaviorsFactory.Parameter> {
        ParsedFile<ModelUnit> parseRes;

        public VarVisitor(ParsedFile<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public AntlrAstToAleBehaviorsFactory.Parameter visitRVariable(ALEParser.RVariableContext ctx) {
            ALEParser.RTypeContext type = ctx.type;
            String name = ctx.Ident().getText();
            AntlrAstToAleBehaviorsFactory.Parameter res = AntlrAstToAleBehaviorsFactory.singleton.buildParameter(type, name, ctx);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
            this.parseRes.setLines(res, lines);
            return res;
        }
    }
}

