/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFImageElementBridge;
import org.apache.fop.svg.PDFTextElementBridge;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDFTranscoder
extends AbstractFOPTranscoder
implements Configurable {
    private Configuration cfg = null;
    protected PDFDocumentGraphics2D graphics = null;

    public PDFTranscoder() {
        this.handler = new AbstractFOPTranscoder.FOPErrorHandler();
    }

    protected UserAgent createUserAgent() {
        return new AbstractFOPTranscoder.FOPTranscoderUserAgent(){

            public float getPixelUnitToMillimeter() {
                return super.getPixelUnitToMillimeter();
            }
        };
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        this.graphics = new PDFDocumentGraphics2D();
        this.graphics.setLogger(this.getLogger());
        try {
            if (this.cfg != null) {
                ContainerUtil.configure(this.graphics, this.cfg);
            }
            ContainerUtil.initialize(this.graphics);
        }
        catch (Exception e) {
            throw new TranscoderException("Error while setting up PDFDocumentGraphics2D", e);
        }
        super.transcode(document, uri, output);
        this.getLogger().trace("document size: " + this.width + " x " + this.height);
        UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)this.ctx, (Element)document.getDocumentElement());
        float widthInPt = UnitProcessor.userSpaceToSVG((float)this.width, (short)9, (short)2, (UnitProcessor.Context)uctx);
        int w = (int)((double)widthInPt + 0.5);
        float heightInPt = UnitProcessor.userSpaceToSVG((float)this.height, (short)9, (short)2, (UnitProcessor.Context)uctx);
        int h = (int)((double)heightInPt + 0.5);
        this.getLogger().trace("document size: " + w + "pt x " + h + "pt");
        try {
            this.graphics.setupDocument(output.getOutputStream(), w, h);
            this.graphics.setSVGDimension(this.width, this.height);
            if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                this.graphics.setBackgroundColor((Color)this.hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.setTransform(this.curTxf);
            this.graphics.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, RenderingHintsKeyExt.VALUE_TRANSCODING_VECTOR);
            this.root.paint((Graphics2D)((Object)this.graphics));
            this.graphics.finish();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }

    protected BridgeContext createBridgeContext() {
        BridgeContext ctx = new BridgeContext(this.userAgent);
        StrokingTextPainter textPainter = null;
        textPainter = new StrokingTextPainter();
        ctx.setTextPainter((TextPainter)textPainter);
        PDFTextElementBridge pdfTextElementBridge = new PDFTextElementBridge(this.graphics.getFontInfo());
        ctx.putBridge((Bridge)pdfTextElementBridge);
        PDFAElementBridge pdfAElementBridge = new PDFAElementBridge();
        AffineTransform currentTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        pdfAElementBridge.setCurrentTransform(currentTransform);
        ctx.putBridge((Bridge)pdfAElementBridge);
        ctx.putBridge((Bridge)new PDFImageElementBridge());
        return ctx;
    }
}

