/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.layout;

import java.util.Iterator;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class LineLayout
extends FlowLayout {
    private int margin;

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension prefSize = new Dimension();
        Iterator children = container.getChildren().iterator();
        int width = this.margin * 2;
        int height = this.margin * 2;
        if (children.hasNext()) {
            IFigure child = (IFigure)children.next();
            Dimension childSize = this.transposer.t(this.getChildSize(child, -1, -1));
            width = childSize.width;
            height = childSize.height;
            while (children.hasNext()) {
                child = (IFigure)children.next();
                childSize = this.transposer.t(this.getChildSize(child, -1, -1));
                width += childSize.width + this.getMinorSpacing();
                height = Math.max(height, childSize.height);
            }
        }
        prefSize.height += height;
        prefSize.width = Math.max(prefSize.width, width);
        prefSize = this.transposer.t(prefSize);
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    public void layout(IFigure parent) {
        this.data = new WorkingData();
        Rectangle relativeArea = parent.getClientArea();
        this.data.area = this.transposer.t(relativeArea);
        Iterator iterator = parent.getChildren().iterator();
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            wHint = parent.getClientArea().width;
        } else {
            hHint = parent.getClientArea().height;
        }
        this.initVariables(parent);
        this.initRow();
        while (iterator.hasNext()) {
            IFigure f = (IFigure)iterator.next();
            Dimension pref = this.transposer.t(this.getChildSize(f, wHint, hHint));
            Rectangle r = new Rectangle(0, 0, pref.width, pref.height);
            r.x = this.data.rowX;
            r.y = this.data.rowY;
            int dx = r.width + this.getMinorSpacing();
            this.data.rowX += dx;
            this.data.rowWidth += dx;
            this.data.rowHeight = Math.max(this.data.rowHeight, r.height);
            this.data.row[this.data.rowCount] = f;
            this.data.bounds[this.data.rowCount] = r;
            ++this.data.rowCount;
        }
        this.data.rowWidth += this.margin;
        this.data.rowHeight += this.margin;
        if (this.data.rowCount != 0) {
            this.layoutRow(parent);
        }
        this.data = null;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int newMargin) {
        this.margin = newMargin;
    }

    protected void initRow() {
        super.initRow();
        this.data.rowX = this.margin;
        this.data.rowY = this.margin;
    }

    protected class WorkingData
    extends FlowLayout.WorkingData {
        protected WorkingData() {
            super((FlowLayout)LineLayout.this);
        }
    }
}

