/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.impl.XtextBuilder;
import org.eclipse.xtext.resource.IResourceDescription;

public class BuildContext
implements IXtextBuilderParticipant.IBuildContext {
    private final ResourceSet resourceSet;
    private final List<IResourceDescription.Delta> deltas;
    private final XtextBuilder builder;
    private final IXtextBuilderParticipant.BuildType type;
    private final Set<URI> sourceLevelURIs;

    public BuildContext(XtextBuilder builder, ResourceSet resourceSet, List<IResourceDescription.Delta> deltas, Set<URI> sourceLevelURIs, IXtextBuilderParticipant.BuildType type) {
        this.builder = builder;
        this.resourceSet = resourceSet;
        this.deltas = deltas;
        this.sourceLevelURIs = sourceLevelURIs;
        this.type = type;
    }

    @Override
    public IProject getBuiltProject() {
        return this.builder.getProject();
    }

    @Override
    public List<IResourceDescription.Delta> getDeltas() {
        return this.deltas;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public boolean isSourceLevelURI(URI uri) {
        return this.sourceLevelURIs.contains(uri);
    }

    @Override
    public void needRebuild() {
        this.builder.needRebuild();
    }

    @Override
    public IXtextBuilderParticipant.BuildType getBuildType() {
        return this.type;
    }
}

