/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEnvironmentListener;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.ExtensionLookupEngine;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;

public class ExtensionEnvironment
implements IQueryEnvironment {
    private BasicLookupEngine lookupEngine;
    private EPackageProvider ePackageProvider;
    private List<IQueryEnvironmentListener> listeners = new ArrayList<IQueryEnvironmentListener>();

    public ExtensionEnvironment() {
        this.ePackageProvider = new EPackageProvider();
        this.lookupEngine = new ExtensionLookupEngine((IReadOnlyQueryEnvironment)this);
    }

    public ServiceRegistrationResult registerService(IService service) {
        ServiceRegistrationResult result = this.lookupEngine.registerService(service);
        if (!result.getRegistered().isEmpty()) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.serviceRegistered(result, service);
            }
        }
        return result;
    }

    public void removeService(IService service) {
        IService removedService = this.lookupEngine.removeService(service);
        if (removedService != null) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.serviceRemoved(removedService);
            }
        }
    }

    public void registerEPackage(EPackage ePackage) {
        EPackage registeredEPackage = this.ePackageProvider.registerPackage(ePackage);
        if (registeredEPackage != null) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.ePackageRegistered(ePackage);
            }
            TreeIterator eAllContents = registeredEPackage.eAllContents();
            while (eAllContents.hasNext()) {
                EObject content = (EObject)eAllContents.next();
                if (!(content instanceof EOperation) || ((EOperation)content).getEType() != null) continue;
                EOperation operation = (EOperation)content;
                operation.setEType((EClassifier)ImplementationPackage.eINSTANCE.getVoidEClassifier());
            }
            Set services = ServiceUtils.getServices((EPackage)ePackage);
            ServiceUtils.registerServices((IQueryEnvironment)this, (Set)services);
        }
    }

    public void removeEPackage(EPackage ePackage) {
        Collection ePackages = this.ePackageProvider.removePackage(ePackage);
        for (EPackage ePkg : ePackages) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.ePackageRemoved(ePkg);
            }
        }
    }

    public void removeEPackage(String name) {
        Collection ePackages = this.ePackageProvider.removePackage(name);
        for (EPackage ePackage : ePackages) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.ePackageRemoved(ePackage);
            }
        }
    }

    public void registerCustomClassMapping(EClassifier eClassifier, Class<?> cls) {
        this.ePackageProvider.registerCustomClassMapping(eClassifier, cls);
        for (IQueryEnvironmentListener listener : this.getListeners()) {
            listener.customClassMappingRegistered(eClassifier, cls);
        }
    }

    public BasicLookupEngine getLookupEngine() {
        return this.lookupEngine;
    }

    public EPackageProvider getEPackageProvider() {
        return this.ePackageProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueryEnvironmentListener(IQueryEnvironmentListener listener) {
        if (listener != null) {
            List<IQueryEnvironmentListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        } else {
            throw new IllegalArgumentException("IQueryEnvironmentListener can't be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueryEnvironmentListener(IQueryEnvironmentListener listener) {
        if (listener != null) {
            List<IQueryEnvironmentListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IQueryEnvironmentListener> getListeners() {
        ArrayList<IQueryEnvironmentListener> result;
        List<IQueryEnvironmentListener> list = this.listeners;
        synchronized (list) {
            result = new ArrayList<IQueryEnvironmentListener>(this.listeners);
        }
        return result;
    }

    public boolean isRegisteredService(IService service) {
        return this.lookupEngine.isRegisteredService(service);
    }
}

